/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractValueExpression;

final class CaseInsensitiveEqualExpression
extends AbstractValueExpression {
    private final boolean not;

    CaseInsensitiveEqualExpression(String propertyName, Object value, boolean not) {
        super(propertyName, value);
        this.not = not;
    }

    private String val() {
        return this.strValue().toLowerCase();
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.beanProperty().encryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
        }
        request.addBindValue(this.val());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.beanProperty().decryptProperty(this.propName);
        }
        if (this.not) {
            request.append("lower(").property(pname).append(") != ?");
        } else {
            request.append("lower(").property(pname).append(") = ?");
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.not) {
            builder.append("Ine[").append(this.propName).append(']');
        } else {
            builder.append("Ieq[").append(this.propName).append(']');
        }
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.val());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        CaseInsensitiveEqualExpression that = (CaseInsensitiveEqualExpression)other;
        return this.val().equals(that.val());
    }
}

