/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.InTuples;
import io.ebean.service.SpiInTuples;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import java.util.List;
import java.util.Objects;

final class InTuplesExpression
extends AbstractExpression {
    private final boolean not;
    private final String[] properties;
    private final List<Object[]> entries;

    InTuplesExpression(InTuples pairs, boolean not) {
        super("");
        SpiInTuples inTuples = (SpiInTuples)pairs;
        this.properties = inTuples.properties();
        this.entries = inTuples.entries();
        this.not = not;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (Object[] entry : this.entries) {
            for (Object value : entry) {
                Objects.requireNonNull(value);
                request.addBindValue(value);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.entries.isEmpty()) {
            request.append(this.not ? "1=1" : "1=0");
            return;
        }
        request.append('(');
        for (int i = 0; i < this.properties.length; ++i) {
            if (i > 0) {
                request.append(',');
            }
            request.property(this.properties[i]);
        }
        request.append(") in (");
        this.addSqlBinding(request);
        request.append(')');
    }

    private void addSqlBinding(SpiExpressionRequest request) {
        String eb = this.entryBinding();
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i > 0) {
                request.append(',');
            }
            request.append(eb);
        }
    }

    private String entryBinding() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < this.properties.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        return sb.append(')').toString();
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.not) {
            builder.append("Not");
        }
        builder.append("InTuple[");
        for (String property : this.properties) {
            builder.append(property).append('-');
        }
        builder.append(this.entries.size()).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.entries.size());
        for (Object[] entry : this.entries) {
            for (Object value : entry) {
                key.add(value);
            }
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InTuplesExpression that = (InTuplesExpression)other;
        return this.entries.size() == that.entries.size() && this.entries.equals(that.entries);
    }
}

