/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.Op;
import java.util.Objects;

final class JsonPathExpression
extends AbstractExpression {
    private final String path;
    private final Op operator;
    private final Object value;
    private final Object upperValue;

    JsonPathExpression(String propertyName, String path, Op operator, Object value) {
        super(propertyName);
        this.path = path;
        this.operator = operator;
        this.value = value;
        this.upperValue = null;
    }

    JsonPathExpression(String propertyName, String path, Object value, Object upperValue) {
        super(propertyName);
        this.path = path;
        this.operator = Op.BETWEEN;
        this.value = value;
        this.upperValue = upperValue;
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("JsonPath[");
        builder.append(this.propName).append(" path:").append(this.path).append(" op:").append((Object)this.operator);
        if (this.value != null) {
            builder.append(" ?1");
        }
        if (this.upperValue != null) {
            builder.append(" ?2");
        }
        builder.append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.value).add(this.upperValue);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        JsonPathExpression that = (JsonPathExpression)other;
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.upperValue, that.upperValue);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.platformHandler().json(request, this.propName, this.path, this.operator, this.value);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.value != null) {
            request.addBindValue(this.value);
        }
        if (this.upperValue != null) {
            request.addBindValue(this.upperValue);
        }
    }
}

