/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.FetchPath;
import io.ebean.bean.EntityBean;
import io.ebean.config.JsonConfig;
import io.ebean.text.json.EJson;
import io.ebean.text.json.JsonIOException;
import io.ebean.text.json.JsonWriteBeanVisitor;
import io.ebean.text.json.JsonWriter;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.json.PathStack;
import io.ebeaninternal.server.util.ArrayStack;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class WriteJson
implements SpiJsonWriter {
    private final SpiEbeanServer server;
    private final JsonGenerator generator;
    private final FetchPath fetchPath;
    private final Map<String, JsonWriteBeanVisitor<?>> visitors;
    private final PathStack pathStack;
    private final ArrayStack<Object> parentBeans;
    private final Object objectMapper;
    private final JsonConfig.Include include;
    private final boolean includeLoadedImplicit;

    public WriteJson(SpiEbeanServer server, JsonGenerator generator, FetchPath fetchPath, Map<String, JsonWriteBeanVisitor<?>> visitors, Object objectMapper, JsonConfig.Include include, boolean includeLoadedImplicit) {
        this.server = server;
        this.generator = generator;
        this.fetchPath = fetchPath;
        this.visitors = visitors;
        this.objectMapper = objectMapper;
        this.include = include;
        this.includeLoadedImplicit = includeLoadedImplicit;
        this.parentBeans = new ArrayStack();
        this.pathStack = new PathStack();
    }

    public WriteJson(JsonGenerator generator, JsonConfig.Include include) {
        this.generator = generator;
        this.include = include;
        this.includeLoadedImplicit = true;
        this.visitors = null;
        this.server = null;
        this.fetchPath = null;
        this.objectMapper = null;
        this.parentBeans = null;
        this.pathStack = null;
    }

    public boolean isIncludeNull() {
        return this.include == JsonConfig.Include.ALL;
    }

    public boolean isIncludeEmpty() {
        return this.include != JsonConfig.Include.NON_EMPTY;
    }

    public JsonGenerator gen() {
        return this.generator;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    public void writeStartObject(String key) {
        try {
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeStartArray(String key) {
        try {
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeRaw(String text) {
        try {
            this.generator.writeRaw(text);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeRawValue(String text) {
        try {
            this.generator.writeRawValue(text);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeFieldName(String name) {
        try {
            this.generator.writeFieldName(name);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNullField(String name) {
        if (this.isIncludeNull()) {
            try {
                this.generator.writeNullField(name);
            }
            catch (IOException e) {
                throw new JsonIOException((Throwable)e);
            }
        }
    }

    public void writeNumberField(String name, long value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumberField(String name, double value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumberField(String name, int value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumberField(String name, short value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumberField(String name, float value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumberField(String name, BigDecimal value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeStringField(String name, String value) {
        try {
            this.generator.writeStringField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeBinary(InputStream is, int length) {
        try {
            this.generator.writeBinary(is, length);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeBinaryField(String name, byte[] value) {
        try {
            this.generator.writeBinaryField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeBooleanField(String name, boolean value) {
        try {
            this.generator.writeBooleanField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeBoolean(boolean value) {
        try {
            this.generator.writeBoolean(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeString(String value) {
        try {
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumber(int value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumber(long value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumber(double value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNumber(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public void writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    @Override
    public boolean parentBean(Object bean) {
        return !this.parentBeans.isEmpty() && this.parentBeans.contains(bean);
    }

    @Override
    public void pushParentBeanMany(EntityBean parentBean) {
        this.parentBeans.push(parentBean);
    }

    @Override
    public void popParentBeanMany() {
        this.parentBeans.pop();
    }

    @Override
    public void beginAssocOne(String key, EntityBean bean) {
        this.parentBeans.push(bean);
        this.pathStack.pushPathKey(key);
    }

    @Override
    public void endAssocOne() {
        this.parentBeans.pop();
        this.pathStack.pop();
    }

    @Override
    public void beginAssocMany(String key) {
        try {
            this.pathStack.pushPathKey(key);
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    @Override
    public void endAssocMany() {
        try {
            this.pathStack.pop();
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    @Override
    public void beginAssocManyMap(String key, boolean elementCollection) {
        try {
            this.pathStack.pushPathKey(key);
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            if (elementCollection) {
                this.generator.writeStartObject();
            } else {
                this.generator.writeStartArray();
            }
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    @Override
    public void endAssocManyMap(boolean elementCollection) {
        try {
            this.pathStack.pop();
            if (elementCollection) {
                this.generator.writeEndObject();
            } else {
                this.generator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    @Override
    public <T> void writeBean(BeanDescriptor<T> desc, EntityBean bean) {
        this.createWriteBean(desc, bean).write(this);
    }

    private <T> WriteBean createWriteBean(BeanDescriptor<T> desc, EntityBean bean) {
        JsonWriteBeanVisitor<?> visitor;
        String path = (String)this.pathStack.peekWithNull();
        JsonWriteBeanVisitor<?> jsonWriteBeanVisitor = visitor = this.visitors == null ? null : this.visitors.get(path);
        if (this.fetchPath == null) {
            return new WriteBean(desc, bean, visitor);
        }
        boolean explicitAllProps = false;
        Set currentIncludeProps = this.fetchPath.getProperties(path);
        if (currentIncludeProps != null && ((explicitAllProps = currentIncludeProps.contains("*")) || currentIncludeProps.isEmpty())) {
            currentIncludeProps = null;
        }
        return new WriteBean(desc, explicitAllProps, this.includeLoadedImplicit, currentIncludeProps, bean, visitor);
    }

    @Override
    public void writeValueUsingObjectMapper(String name, Object value) {
        if (!this.isIncludeEmpty()) {
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                return;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                return;
            }
        }
        try {
            this.generator.writeFieldName(name);
            this.objectMapper().writeValue(this.generator, value);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private ObjectMapper objectMapper() {
        if (this.objectMapper == null) {
            throw new IllegalStateException("Jackson ObjectMapper required but not set. Expected to be set on DatabaseConfig");
        }
        return (ObjectMapper)this.objectMapper;
    }

    @Override
    public Boolean includeMany(String key) {
        if (this.fetchPath != null) {
            String fullPath = this.pathStack.peekFullPath(key);
            return this.fetchPath.hasPath(fullPath);
        }
        return null;
    }

    @Override
    public void toJson(String name, Collection<?> c) {
        try {
            this.beginAssocMany(name);
            for (Object bean : c) {
                BeanDescriptor<?> d = this.getDescriptor(bean.getClass());
                d.jsonWrite(this, (EntityBean)bean, null);
            }
            this.endAssocMany();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private <T> BeanDescriptor<T> getDescriptor(Class<T> cls) {
        BeanDescriptor<T> d = this.server.descriptor(cls);
        if (d == null) {
            throw new RuntimeException("No BeanDescriptor found for " + String.valueOf(cls));
        }
        return d;
    }

    public static class WriteBean {
        final boolean explicitAllProps;
        final boolean includeLoadedImplicit;
        final Set<String> currentIncludeProps;
        final BeanDescriptor<?> desc;
        final EntityBean currentBean;
        final JsonWriteBeanVisitor visitor;

        WriteBean(BeanDescriptor<?> desc, EntityBean currentBean, JsonWriteBeanVisitor<?> visitor) {
            this(desc, false, true, null, currentBean, visitor);
        }

        WriteBean(BeanDescriptor<?> desc, boolean explicitAllProps, boolean includeLoadedImplicit, Set<String> currentIncludeProps, EntityBean currentBean, JsonWriteBeanVisitor<?> visitor) {
            this.desc = desc;
            this.currentBean = currentBean;
            this.explicitAllProps = explicitAllProps;
            this.includeLoadedImplicit = includeLoadedImplicit;
            this.currentIncludeProps = currentIncludeProps;
            this.visitor = visitor;
        }

        private boolean isReferenceOnly() {
            return !this.explicitAllProps && this.currentIncludeProps == null && this.currentBean._ebean_getIntercept().isReference();
        }

        private boolean isIncludeProperty(BeanProperty prop) {
            if (this.explicitAllProps) {
                return true;
            }
            if (this.currentIncludeProps != null) {
                return this.currentIncludeProps.contains(prop.name());
            }
            if (this.includeLoadedImplicit) {
                return this.currentBean._ebean_getIntercept().isLoadedProperty(prop.propertyIndex());
            }
            return prop.isId();
        }

        private boolean isIncludeTransientProperty(BeanProperty prop) {
            if (prop.isUnmappedJson()) {
                return false;
            }
            if (!this.explicitAllProps && this.currentIncludeProps != null) {
                return this.currentIncludeProps.contains(prop.name());
            }
            return true;
        }

        public void write(WriteJson writeJson) {
            try {
                Map map;
                BeanProperty unmappedJson;
                BeanProperty beanProp = this.desc.idProperty();
                if (beanProp != null && this.isIncludeProperty(beanProp)) {
                    beanProp.jsonWrite(writeJson, this.currentBean);
                }
                if (!this.isReferenceOnly()) {
                    BeanProperty[] props;
                    for (BeanProperty prop1 : props = this.desc.propertiesNonTransient()) {
                        if (!this.isIncludeProperty(prop1)) continue;
                        prop1.jsonWrite(writeJson, this.currentBean);
                    }
                    for (BeanProperty prop : props = this.desc.propertiesTransient()) {
                        if (!this.isIncludeTransientProperty(prop)) continue;
                        prop.jsonWrite(writeJson, this.currentBean);
                    }
                }
                if ((unmappedJson = this.desc.propertyUnmappedJson()) != null && unmappedJson.isJsonSerialize() && (map = (Map)unmappedJson.getValue(this.currentBean)) != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        writeJson.writeFieldName((String)entry.getKey());
                        EJson.write(entry.getValue(), (JsonGenerator)writeJson.generator);
                    }
                }
                if (this.visitor != null) {
                    this.visitor.visit((Object)this.currentBean, (JsonWriter)writeJson);
                }
            }
            catch (IOException e) {
                throw new JsonIOException((Throwable)e);
            }
        }
    }
}

