/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.PersistenceContextScope;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.List;

final class DeleteUnloadedForeignKeys {
    private final List<BeanPropertyAssocOne<?>> propList = new ArrayList(4);
    private final SpiEbeanServer server;
    private final PersistRequestBean<?> request;
    private final boolean deletePermanent;
    private EntityBean beanWithForeignKeys;

    DeleteUnloadedForeignKeys(SpiEbeanServer server, PersistRequestBean<?> request) {
        this.server = server;
        this.request = request;
        this.deletePermanent = request.isHardDeleteCascade();
    }

    public void add(BeanPropertyAssocOne<?> prop) {
        this.propList.add(prop);
    }

    void queryForeignKeys() {
        BeanDescriptor<?> descriptor = this.request.descriptor();
        Query q = this.server.createQuery((Class)descriptor.type());
        q.usingTransaction(this.request.transaction());
        Object id = this.request.beanId();
        StringBuilder sb = new StringBuilder(30);
        for (BeanPropertyAssocOne<?> aPropList : this.propList) {
            sb.append(aPropList.name()).append(',');
        }
        q.setPersistenceContext(new DefaultPersistenceContext());
        q.setPersistenceContextScope(PersistenceContextScope.QUERY);
        q.setAutoTune(false);
        q.select(sb.toString());
        q.setIncludeSoftDeletes();
        q.where().idEq(id);
        Transaction t = this.request.transaction();
        if (t.isLogSummary()) {
            t.logSummary("-- Ebean fetching foreign key values for delete of {0} id:{1}", descriptor.name(), id);
        }
        this.beanWithForeignKeys = (EntityBean)this.server.findOne(q);
    }

    void deleteCascade() {
        if (this.beanWithForeignKeys != null) {
            for (BeanPropertyAssocOne<?> prop : this.propList) {
                Object detailBean = prop.getValue(this.beanWithForeignKeys);
                if (detailBean == null || !prop.hasId((EntityBean)detailBean)) continue;
                if (this.deletePermanent) {
                    this.server.deletePermanent(detailBean, this.request.transaction());
                    continue;
                }
                this.server.delete(detailBean, this.request.transaction());
            }
        }
    }
}

