/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.Transaction;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdatePlan;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.UpdateMeta;
import jakarta.persistence.OptimisticLockException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class UpdateHandler
extends DmlHandler {
    private final UpdateMeta meta;
    private boolean emptySetClause;

    UpdateHandler(PersistRequestBean<?> persist, UpdateMeta meta) {
        super(persist);
        this.meta = meta;
    }

    @Override
    public boolean isUpdate() {
        return true;
    }

    @Override
    public void bind() throws SQLException {
        SpiUpdatePlan updatePlan = this.meta.updatePlan(this.persistRequest);
        if (updatePlan.isEmptySetClause()) {
            this.emptySetClause = true;
            return;
        }
        this.sql = updatePlan.sql();
        Transaction t = this.persistRequest.transaction();
        PreparedStatement pstmt = this.persistRequest.isBatched() ? this.pstmtBatch((SpiTransaction)t, this.sql, this.persistRequest, false) : this.pstmt((SpiTransaction)t, this.sql, false);
        this.dataBind = this.bind(pstmt);
        this.meta.bind(this.persistRequest, this, updatePlan);
        if (this.persistRequest.isBatched()) {
            this.batchedPstmt.registerInputStreams(this.dataBind.getInputStreams());
        }
        this.logSql(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        if (!this.emptySetClause) {
            super.addBatch();
        }
    }

    @Override
    public int execute() throws SQLException, OptimisticLockException {
        if (!this.emptySetClause) {
            int rowCount = this.dataBind.executeUpdate();
            this.checkRowCount(rowCount);
            return rowCount;
        }
        return 0;
    }
}

