/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.SqlTree;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.type.RsetDataReaderIndexed;
import java.sql.ResultSet;
import java.util.List;

final class CQueryPlanRawSql
extends CQueryPlan {
    private final int[] rsetIndexPositions;

    CQueryPlanRawSql(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, String logWhereSql) {
        super(request, sqlRes, sqlTree.plan(), true, logWhereSql);
        this.rsetIndexPositions = this.createIndexPositions(request, sqlTree);
    }

    @Override
    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReaderIndexed(this.dataTimeZone, rset, this.rsetIndexPositions);
    }

    private int[] createIndexPositions(OrmQueryRequest<?> request, SqlTree sqlTree) {
        int i;
        List<String> chain = sqlTree.buildRawSqlSelectChain();
        SpiRawSql.ColumnMapping columnMapping = request.query().rawSql().getColumnMapping();
        int[] indexPositions = new int[chain.size()];
        for (i = 0; i < chain.size(); ++i) {
            String logicalPropertyPath = chain.get(i);
            int mappedPosition = columnMapping.getIndexPosition(logicalPropertyPath);
            if (mappedPosition == -1 && logicalPropertyPath.endsWith(".id")) {
                mappedPosition = columnMapping.getIndexPosition(this.foreignKeyPath(logicalPropertyPath));
            }
            indexPositions[i] = 1 + mappedPosition;
        }
        for (i = 0; i < indexPositions.length; ++i) {
            if (indexPositions[i] != 0) continue;
            indexPositions[i] = indexPositions[i + 1] - 1;
        }
        return indexPositions;
    }

    private String foreignKeyPath(String logicalPropertyPath) {
        return logicalPropertyPath.substring(0, logicalPropertyPath.length() - 3) + "Id";
    }
}

