/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.PagedList;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import jakarta.persistence.PersistenceException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public final class LimitOffsetPagedList<T>
implements PagedList<T> {
    private final transient SpiEbeanServer server;
    private final transient ReentrantLock lock = new ReentrantLock();
    private final SpiQuery<T> query;
    private final int firstRow;
    private final int maxRows;
    private int foregroundTotalRowCount = -1;
    private Future<Integer> futureRowCount;
    private List<T> list;

    public LimitOffsetPagedList(SpiEbeanServer server, SpiQuery<T> query) {
        this.server = server;
        this.query = query;
        this.maxRows = query.getMaxRows();
        this.firstRow = query.getFirstRow();
    }

    public void loadCount() {
        this.getFutureCount();
    }

    public Future<Integer> getFutureCount() {
        this.lock.lock();
        try {
            if (this.futureRowCount == null) {
                this.futureRowCount = this.server.findFutureCount(this.query);
            }
            Future<Integer> future = this.futureRowCount;
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> getList() {
        this.lock.lock();
        try {
            if (this.list == null) {
                this.list = this.server.findList(this.query);
            }
            List<T> list = this.list;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPageIndex() {
        if (this.firstRow == 0) {
            return 0;
        }
        return (this.firstRow - 1) / this.maxRows + 1;
    }

    public int getTotalPageCount() {
        int rowCount = this.getTotalCount();
        if (rowCount == 0) {
            return 0;
        }
        return (rowCount - 1) / this.maxRows + 1;
    }

    public int getTotalCount() {
        this.lock.lock();
        try {
            if (this.futureRowCount != null) {
                try {
                    int n = this.futureRowCount.get();
                    return n;
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            if (this.foregroundTotalRowCount > -1) {
                int n = this.foregroundTotalRowCount;
                return n;
            }
            int n = this.foregroundTotalRowCount = this.server.findCount(this.query);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasNext() {
        return this.firstRow + this.maxRows < this.getTotalCount();
    }

    public boolean hasPrev() {
        return this.firstRow > 0;
    }

    public int getPageSize() {
        return this.maxRows;
    }

    public String getDisplayXtoYofZ(String to, String of) {
        int first = this.firstRow + 1;
        int last = this.firstRow + this.getList().size();
        int total = this.getTotalCount();
        return first + to + last + of + total;
    }
}

