/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionFactoryBasic;
import io.ebeaninternal.server.transaction.TransactionFactoryBasicWithRead;
import io.ebeaninternal.server.transaction.TransactionFactoryTenant;
import io.ebeaninternal.server.transaction.TransactionFactoryTenantWithRead;
import io.ebeaninternal.server.transaction.TransactionManager;

final class TransactionFactoryBuilder {
    TransactionFactoryBuilder() {
    }

    static TransactionFactory build(TransactionManager manager, DataSourceSupplier dataSourceSupplier, CurrentTenantProvider tenantProvider) {
        boolean hasReadOnlyDataSource;
        boolean bl = hasReadOnlyDataSource = dataSourceSupplier.readOnlyDataSource() != null;
        if (tenantProvider == null) {
            if (hasReadOnlyDataSource) {
                return new TransactionFactoryBasicWithRead(manager, dataSourceSupplier);
            }
            return new TransactionFactoryBasic(manager, dataSourceSupplier);
        }
        if (hasReadOnlyDataSource) {
            return new TransactionFactoryTenantWithRead(manager, dataSourceSupplier, tenantProvider);
        }
        return new TransactionFactoryTenant(manager, dataSourceSupplier, tenantProvider);
    }
}

