/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanEmbedded;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import io.ebeaninternal.server.query.SqlJoinType;
import jakarta.persistence.CascadeType;

public final class DeployBeanPropertyAssocOne<T>
extends DeployBeanPropertyAssoc<T> {
    private boolean oneToOne;
    private boolean oneToOneExported;
    private boolean primaryKeyJoin;
    private boolean primaryKeyExport;
    private DeployBeanEmbedded deployEmbedded;
    private String columnPrefix;

    public DeployBeanPropertyAssocOne(DeployBeanDescriptor<?> desc, Class<T> targetType) {
        super(desc, targetType);
    }

    public DeployBeanEmbedded getDeployEmbedded() {
        if (this.deployEmbedded == null) {
            this.deployEmbedded = new DeployBeanEmbedded();
        }
        return this.deployEmbedded;
    }

    public boolean isCompound() {
        return this.getDeployEmbedded().getPropertyColumnMap().size() > 1;
    }

    @Override
    public String getDbColumn() {
        DeployTableJoinColumn[] columns = this.tableJoin.columns();
        if (columns.length == 1) {
            return columns[0].getLocalDbColumn();
        }
        return super.getDbColumn();
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public void setOneToOne() {
        this.oneToOne = true;
    }

    public boolean isOneToOneExported() {
        return this.oneToOneExported;
    }

    public void setOneToOneExported() {
        this.oneToOneExported = true;
    }

    @Override
    public void setImportedPrimaryKeyColumn(DeployBeanProperty primaryKey) {
        this.importedPrimaryKey = true;
        String dbColumn = primaryKey.getDbColumn();
        if (dbColumn != null) {
            this.tableJoin.setLocalColumn(dbColumn);
        }
    }

    @Override
    public void setSqlFormula(String formulaSelect, String formulaJoin) {
        super.setSqlFormula(formulaSelect, formulaJoin);
        DeployTableJoinColumn[] columns = this.tableJoin.columns();
        if (columns.length == 1) {
            columns[0].setLocalSqlFormula(formulaSelect);
        }
    }

    public void setColumnPrefix(String columnPrefix) {
        this.columnPrefix = columnPrefix;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    public void setPrimaryKeyJoin(boolean primaryKeyJoin) {
        this.primaryKeyJoin = primaryKeyJoin;
    }

    public boolean isPrimaryKeyJoin() {
        return this.primaryKeyJoin;
    }

    public boolean isPrimaryKeyExport() {
        return this.primaryKeyExport;
    }

    public void setPrimaryKeyExport() {
        this.primaryKeyExport = true;
        this.oneToOneExported = true;
        if (!this.cascadeInfo.isSave()) {
            this.cascadeInfo.setType(CascadeType.ALL);
        }
    }

    public void setJoinType(boolean outerJoin) {
        this.tableJoin.setType(outerJoin ? SqlJoinType.OUTER : SqlJoinType.INNER);
    }

    public void setJoinColumns(DeployTableJoinColumn[] columns, boolean reverse) {
        this.tableJoin.setColumns(columns, reverse);
    }
}

