/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanTable;

public final class DeployTableJoinColumn {
    private String localDbColumn;
    private String localSqlFormula;
    private String foreignDbColumn;
    private String foreignSqlFormula;
    private boolean insertable;
    private boolean updatable;
    private boolean nullable;

    public DeployTableJoinColumn(String localDbColumn, String foreignDbColumn) {
        this(localDbColumn, foreignDbColumn, true, true, true);
    }

    public DeployTableJoinColumn(String localDbColumn, String foreignDbColumn, boolean insertable, boolean updatable, boolean nullable) {
        this.localDbColumn = this.nullEmptyString(localDbColumn);
        this.foreignDbColumn = this.nullEmptyString(foreignDbColumn);
        this.insertable = insertable;
        this.updatable = updatable;
        this.nullable = nullable;
    }

    public DeployTableJoinColumn(boolean order, String ref, String name, boolean insertable, boolean updatable, boolean nullable, BeanTable beanTable) {
        this(ref, name, insertable, updatable, nullable);
        this.setReferencedColumn(beanTable);
        if (!order) {
            this.reverse();
        }
    }

    void setLocalSqlFormula(String localSqlFormula) {
        if (localSqlFormula != null) {
            this.localSqlFormula = localSqlFormula;
            this.localDbColumn = null;
            this.insertable = false;
            this.updatable = false;
        }
    }

    public String getLocalSqlFormula() {
        return this.localSqlFormula;
    }

    public void setForeignSqlFormula(String foreignSqlFormula) {
        if (foreignSqlFormula != null) {
            this.foreignSqlFormula = foreignSqlFormula;
            this.foreignDbColumn = null;
            this.insertable = false;
            this.updatable = false;
        }
    }

    public String getForeignSqlFormula() {
        return this.foreignSqlFormula;
    }

    private void setReferencedColumn(BeanTable beanTable) {
        BeanProperty idProperty;
        if (this.localDbColumn == null && (idProperty = beanTable.getIdProperty()) != null) {
            this.localDbColumn = idProperty.dbColumn();
        }
    }

    public DeployTableJoinColumn reverse() {
        String temp = this.localDbColumn;
        this.localDbColumn = this.foreignDbColumn;
        this.foreignDbColumn = temp;
        temp = this.localSqlFormula;
        this.localSqlFormula = this.foreignSqlFormula;
        this.foreignSqlFormula = temp;
        return this;
    }

    private String nullEmptyString(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    public DeployTableJoinColumn copy(boolean reverse) {
        DeployTableJoinColumn ret;
        if (reverse) {
            ret = new DeployTableJoinColumn(this.foreignDbColumn, this.localDbColumn, this.insertable, this.updatable, this.nullable);
            ret.setLocalSqlFormula(this.foreignSqlFormula);
            ret.setForeignSqlFormula(this.localSqlFormula);
        } else {
            ret = new DeployTableJoinColumn(this.localDbColumn, this.foreignDbColumn, this.insertable, this.updatable, this.nullable);
            ret.setLocalSqlFormula(this.localSqlFormula);
            ret.setForeignSqlFormula(this.foreignSqlFormula);
        }
        return ret;
    }

    public String toString() {
        return this.localDbColumn + " = " + this.foreignDbColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getForeignDbColumn() {
        return this.foreignDbColumn;
    }

    public String getLocalDbColumn() {
        return this.localDbColumn;
    }

    void setLocalDbColumn(String localDbColumn) {
        this.localDbColumn = localDbColumn;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

