/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractValueExpression;
import io.ebeaninternal.server.expression.Op;

public final class SimpleExpression
extends AbstractValueExpression {
    private final Op type;

    public SimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName, value);
        this.type = type;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        if (this.type == Op.EQ && idName.equals(this.propName)) {
            return this.value();
        }
        return null;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        if (this.type != Op.EQ) {
            return false;
        }
        return data.matchEq(this.propName, this.bindValue);
    }

    public String getPropName() {
        return this.propName;
    }

    public boolean isOpEquals() {
        return Op.EQ == this.type;
    }

    public Object getValue() {
        return this.value();
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.assocIdValues((EntityBean)this.value());
                if (ids != null) {
                    for (Object id : ids) {
                        request.addBindValue(id);
                    }
                }
                return;
            }
            if (prop.isDbEncrypted()) {
                String encryptKey = prop.beanProperty().encryptKey().getStringValue();
                request.addBindEncryptKey(encryptKey);
            } else if (prop.isLocalEncrypted()) {
                Object bindVal = prop.localEncrypt(this.value());
                request.addBindEncryptKey(bindVal);
                return;
            }
        }
        request.addBindValue(this.value());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.parse(prop.assocIdExpression(this.propName, this.type.bind()));
                return;
            }
            if (prop.isDbEncrypted()) {
                String dsql = prop.beanProperty().decryptProperty(this.propName);
                request.parse(dsql).append(this.type.bind());
                return;
            }
        }
        request.property(this.propName).append(this.type.bind());
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append(this.type.name()).append('[').append(this.propName).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.value());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        SimpleExpression that = (SimpleExpression)other;
        return this.value().equals(that.value());
    }
}

