/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebean.TransactionCallback;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiPersistenceContext;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTxnLogger;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TxnProfileEventCodes;
import io.ebeaninternal.server.core.PersistDeferredRelationship;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.BatchedSqlException;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TChangeLogHolder;
import io.ebeaninternal.server.transaction.TransactionManager;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class JdbcTransaction
implements SpiTransaction,
TxnProfileEventCodes {
    private static final System.Logger log = CoreLog.log;
    private static final Object PLACEHOLDER = new Object();
    private static final String illegalStateMessage = "Transaction is Inactive";
    final TransactionManager manager;
    private final SpiTxnLogger logger;
    private final String id;
    private final boolean logSql;
    private final boolean logSummary;
    private final boolean explicit;
    private final boolean onQueryOnlyCommit;
    private String label;
    private boolean active;
    private boolean rollbackOnly;
    private boolean nestedUseSavepoint;
    Connection connection;
    private BatchControl batchControl;
    private TransactionEvent event;
    private SpiPersistenceContext persistenceContext;
    private boolean persistCascade = true;
    private boolean queryOnly = true;
    private boolean localReadOnly;
    private Boolean updateAllLoadedProperties;
    private boolean oldBatchMode;
    private boolean batchMode;
    private boolean batchOnCascadeMode;
    private int batchSize = -1;
    private boolean batchFlushOnQuery = true;
    private Boolean batchGetGeneratedKeys;
    private Boolean batchFlushOnMixed;
    private Object tenantId;
    private int depth;
    private boolean autoCommit;
    private IdentityHashMap<Object, Object> persistingBeans;
    private HashSet<Integer> deletingBeansHash;
    private HashMap<String, String> m2mIntersectionSave;
    private Map<String, Object> userObjects;
    private List<TransactionCallback> callbackList;
    private boolean batchOnCascadeSet;
    private TChangeLogHolder changeLogHolder;
    private List<PersistDeferredRelationship> deferredList;
    private Boolean skipCache;
    private final boolean skipCacheAfterWrite;
    private ProfileStream profileStream;
    private ProfileLocation profileLocation;
    private final long startNanos;
    private boolean autoPersistUpdates;

    JdbcTransaction(boolean explicit, Connection connection, TransactionManager manager) {
        try {
            this.active = true;
            this.explicit = explicit;
            this.manager = manager;
            this.connection = connection;
            this.persistenceContext = new DefaultPersistenceContext();
            this.startNanos = System.nanoTime();
            if (manager == null) {
                this.logger = null;
                this.id = "";
                this.logSql = false;
                this.logSummary = false;
                this.skipCacheAfterWrite = true;
                this.batchMode = false;
                this.batchOnCascadeMode = false;
                this.onQueryOnlyCommit = false;
            } else {
                this.logger = manager.logger();
                this.id = this.logger.id();
                this.autoPersistUpdates = explicit && manager.isAutoPersistUpdates();
                this.logSql = this.logger.isLogSql();
                this.logSummary = this.logger.isLogSummary();
                this.skipCacheAfterWrite = manager.isSkipCacheAfterWrite();
                this.batchMode = manager.isPersistBatch();
                this.batchOnCascadeMode = manager.isPersistBatchOnCascade();
                this.onQueryOnlyCommit = true;
            }
            this.checkAutoCommit(connection);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    @Override
    public final String label() {
        return this.label;
    }

    @Override
    public final long startNanoTime() {
        return this.startNanos;
    }

    @Override
    public final long profileOffset() {
        return this.profileStream == null ? 0L : this.profileStream.offset();
    }

    @Override
    public final void profileEvent(SpiProfileTransactionEvent event) {
        if (this.profileStream != null) {
            event.profile();
        }
    }

    @Override
    public final void setProfileStream(ProfileStream profileStream) {
        this.profileStream = profileStream;
    }

    @Override
    public final ProfileStream profileStream() {
        return this.profileStream;
    }

    @Override
    public final void setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
    }

    @Override
    public final ProfileLocation profileLocation() {
        return this.profileLocation;
    }

    final void checkAutoCommit(Connection connection) throws SQLException {
        if (connection != null) {
            this.autoCommit = connection.getAutoCommit();
            if (this.autoCommit) {
                connection.setAutoCommit(false);
            }
        }
    }

    public final void setAutoPersistUpdates(boolean autoPersistUpdates) {
        this.autoPersistUpdates = autoPersistUpdates;
        this.batchMode = true;
    }

    @Override
    public final boolean isAutoPersistUpdates() {
        return this.autoPersistUpdates;
    }

    @Override
    public final boolean isSkipCacheExplicit() {
        return this.skipCache != null && this.skipCache == false;
    }

    public final boolean isSkipCache() {
        if (this.skipCache != null) {
            return this.skipCache;
        }
        return this.skipCacheAfterWrite && !this.queryOnly;
    }

    public final void setSkipCache(boolean skipCache) {
        this.skipCache = skipCache;
    }

    public String toString() {
        if (this.active) {
            return this.id;
        }
        return this.id + "(inactive)";
    }

    @Override
    public final void addBeanChange(BeanChange beanChange) {
        if (this.changeLogHolder == null) {
            this.changeLogHolder = new TChangeLogHolder(this, 100);
        }
        this.changeLogHolder.addBeanChange(beanChange);
    }

    @Override
    public final void sendChangeLog(ChangeSet changesRequest) {
        if (this.manager != null) {
            this.manager.sendChangeLog(changesRequest);
        }
    }

    public final void register(TransactionCallback callback) {
        if (this.callbackList == null) {
            this.callbackList = new ArrayList<TransactionCallback>(4);
        }
        this.callbackList.add(callback);
    }

    private void withEachCallbackFailSilent(Consumer<TransactionCallback> consumer) {
        if (this.callbackList != null) {
            for (int i = 0; i < this.callbackList.size(); ++i) {
                try {
                    consumer.accept(this.callbackList.get(i));
                    continue;
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.ERROR, "Error executing transaction callback", (Throwable)e);
                    throw this.wrapIfNeeded(e);
                }
            }
        }
    }

    private void withEachCallback(Consumer<TransactionCallback> consumer) {
        if (this.callbackList != null) {
            for (int i = 0; i < this.callbackList.size(); ++i) {
                consumer.accept(this.callbackList.get(i));
            }
        }
    }

    private void firePreRollback() {
        this.withEachCallbackFailSilent(TransactionCallback::preRollback);
    }

    private void firePostRollback() {
        this.withEachCallbackFailSilent(TransactionCallback::postRollback);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postRollback();
        }
    }

    private void firePreCommit() {
        this.withEachCallback(TransactionCallback::preCommit);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.preCommit();
        }
    }

    private void firePostCommit() {
        this.withEachCallback(TransactionCallback::postCommit);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postCommit();
        }
    }

    @Override
    public final void registerDeferred(PersistDeferredRelationship derived) {
        if (this.deferredList == null) {
            this.deferredList = new ArrayList<PersistDeferredRelationship>();
        }
        this.deferredList.add(derived);
    }

    @Override
    public final void registerDeleteBean(Integer persistingBean) {
        if (this.deletingBeansHash == null) {
            this.deletingBeansHash = new HashSet();
        }
        this.deletingBeansHash.add(persistingBean);
    }

    @Override
    public final boolean isRegisteredDeleteBean(Integer persistingBean) {
        return this.deletingBeansHash != null && this.deletingBeansHash.contains(persistingBean);
    }

    @Override
    public final void unregisterBeans() {
        this.persistingBeans.clear();
    }

    @Override
    public final boolean isRegisteredBean(Object bean) {
        if (this.persistingBeans == null) {
            this.persistingBeans = new IdentityHashMap();
        }
        return this.persistingBeans.put(bean, PLACEHOLDER) != null;
    }

    @Override
    public final boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        if (this.m2mIntersectionSave == null) {
            this.m2mIntersectionSave = new HashMap();
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        String existingBean = this.m2mIntersectionSave.get(intersectionTable);
        if (existingBean == null) {
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        return existingBean.equals(beanName);
    }

    @Override
    public final void depth(int diff) {
        this.depth += diff;
    }

    @Override
    public final int depth() {
        return this.depth;
    }

    @Override
    public final void depthDecrement() {
        if (this.depth != 0) {
            --this.depth;
        }
    }

    @Override
    public final void depthReset() {
        this.depth = 0;
    }

    @Override
    public final void markNotQueryOnly() {
        this.queryOnly = false;
        if (this.localReadOnly) {
            throw new IllegalStateException("This transaction is read-only");
        }
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        try {
            this.localReadOnly = readOnly;
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public final void setUpdateAllLoadedProperties(boolean updateAllLoadedProperties) {
        this.updateAllLoadedProperties = updateAllLoadedProperties;
    }

    @Override
    public final Boolean isUpdateAllLoadedProperties() {
        return this.updateAllLoadedProperties;
    }

    public final void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public final boolean isBatchMode() {
        return this.batchMode;
    }

    public final void setBatchOnCascade(boolean batchMode) {
        this.batchOnCascadeMode = batchMode;
    }

    public final boolean isBatchOnCascade() {
        return this.batchOnCascadeMode;
    }

    @Override
    public final Boolean getBatchGetGeneratedKeys() {
        return this.batchGetGeneratedKeys;
    }

    public final void setGetGeneratedKeys(boolean getGeneratedKeys) {
        this.batchGetGeneratedKeys = getGeneratedKeys;
        if (this.batchControl != null) {
            this.batchControl.setGetGeneratedKeys(getGeneratedKeys);
        }
    }

    public final void setFlushOnMixed(boolean batchFlushOnMixed) {
        this.batchFlushOnMixed = batchFlushOnMixed;
        if (this.batchControl != null) {
            this.batchControl.setBatchFlushOnMixed(batchFlushOnMixed);
        }
    }

    @Override
    public final int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.batchControl != null) {
            this.batchControl.setBatchSize(batchSize);
        }
    }

    public final boolean isFlushOnQuery() {
        return this.batchFlushOnQuery;
    }

    public final void setFlushOnQuery(boolean batchFlushOnQuery) {
        this.batchFlushOnQuery = batchFlushOnQuery;
    }

    @Override
    public final boolean isBatchThisRequest() {
        return this.batchMode;
    }

    @Override
    public final void checkBatchEscalationOnCollection() {
        if (!this.batchMode && this.batchOnCascadeMode) {
            this.batchMode = true;
            this.batchOnCascadeSet = true;
        }
    }

    @Override
    public final void flushBatchOnCollection() {
        if (this.batchOnCascadeSet) {
            this.batchFlushReset();
            this.batchMode = false;
        }
    }

    private void batchFlush() {
        if (this.batchControl != null) {
            try {
                this.batchControl.flushOnCommit();
            }
            catch (BatchedSqlException e) {
                throw this.translate(e.getMessage(), e.getCause());
            }
        }
    }

    private void batchFlushReset() {
        if (this.batchControl != null) {
            try {
                this.batchControl.flushReset();
            }
            catch (BatchedSqlException e) {
                throw this.translate(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public final PersistenceException translate(String message, SQLException cause) {
        if (this.manager != null) {
            return this.manager.translate(message, cause);
        }
        return new PersistenceException(message, (Throwable)cause);
    }

    @Override
    public final void flushBatchOnCascade() {
        this.batchFlushReset();
        this.batchMode = this.oldBatchMode;
    }

    @Override
    public final void flushBatchOnRollback() {
        this.internalBatchClear();
        this.batchMode = this.oldBatchMode;
    }

    private void internalBatchClear() {
        if (this.batchControl != null) {
            this.batchControl.clear();
        }
    }

    @Override
    public final boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        if (this.batchMode) {
            return false;
        }
        if (this.batchOnCascadeMode) {
            this.oldBatchMode = false;
            this.batchMode = true;
            this.batchFlushReset();
            request.setSkipBatchForTopLevel();
            return true;
        }
        this.batchFlushReset();
        return false;
    }

    @Override
    public final BatchControl batchControl() {
        return this.batchControl;
    }

    @Override
    public final void setBatchControl(BatchControl batchControl) {
        this.queryOnly = false;
        this.batchControl = batchControl;
        if (this.batchGetGeneratedKeys != null) {
            batchControl.setGetGeneratedKeys(this.batchGetGeneratedKeys);
        }
        if (this.batchSize != -1) {
            batchControl.setBatchSize(this.batchSize);
        }
        if (this.batchFlushOnMixed != null) {
            batchControl.setBatchFlushOnMixed(this.batchFlushOnMixed);
        }
    }

    public final void flush() {
        this.internalBatchFlush();
    }

    private void internalBatchFlush() {
        if (this.autoPersistUpdates) {
            this.manager.flushTransparent(this.persistenceContext, this);
        }
        this.batchFlush();
        if (this.deferredList != null) {
            for (PersistDeferredRelationship deferred : this.deferredList) {
                deferred.execute(this);
            }
            this.batchFlush();
            this.deferredList.clear();
        }
    }

    @Override
    public final SpiPersistenceContext persistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public final void setPersistenceContext(SpiPersistenceContext context) {
        this.persistenceContext = context;
    }

    @Override
    public final TransactionEvent event() {
        this.queryOnly = false;
        if (this.event == null) {
            this.event = new TransactionEvent();
        }
        return this.event;
    }

    @Override
    public final boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public final boolean isLogSql() {
        return this.logSql;
    }

    @Override
    public final boolean isLogSummary() {
        return this.logSummary;
    }

    @Override
    public void logSql(String msg, Object ... args) {
        this.logger.sql(msg, args);
    }

    @Override
    public final void logSummary(String msg, Object ... args) {
        this.logger.sum(msg, args);
    }

    @Override
    public void logTxn(String msg, Object ... args) {
        this.logger.txn(msg, args);
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public final Object tenantId() {
        return this.tenantId;
    }

    @Override
    public Connection internalConnection() {
        return this.connection;
    }

    public Connection connection() {
        this.queryOnly = false;
        return this.internalConnection();
    }

    void deactivate() {
        try {
            if (this.localReadOnly) {
                this.connection.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.ERROR, "Error setting to readOnly?", (Throwable)e);
        }
        try {
            if (this.autoCommit) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.ERROR, "Error setting to readOnly?", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            log.log(System.Logger.Level.ERROR, "Error closing connection", (Throwable)ex);
        }
        this.connection = null;
        this.active = false;
        this.profileEnd();
    }

    final void notifyCommit() {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.logger.notifyQueryOnly();
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfCommit(this);
                this.logger.notifyCommit();
            }
        }
    }

    private void connectionEndForQueryOnly() {
        try {
            this.withEachCallback(TransactionCallback::preCommit);
            if (this.onQueryOnlyCommit) {
                this.performCommit();
            } else {
                this.performRollback();
            }
            this.withEachCallback(TransactionCallback::postCommit);
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.ERROR, "Error when ending a query only transaction", (Throwable)e);
        }
    }

    void performRollback() throws SQLException {
        long offset = this.profileOffset();
        this.connection.rollback();
        if (this.profileStream != null) {
            this.profileStream.addEvent("r", offset);
        }
    }

    void performCommit() throws SQLException {
        long offset = this.profileOffset();
        this.connection.commit();
        if (this.profileStream != null) {
            this.profileStream.addEvent("c", offset);
        }
    }

    private void profileEnd() {
        if (this.manager != null) {
            long exeMicros = (System.nanoTime() - this.startNanos) / 1000L;
            if (this.profileLocation != null) {
                this.profileLocation.add(exeMicros);
            } else if (this.label != null) {
                this.manager.collectMetricNamed(exeMicros, this.label);
            }
            this.manager.collectMetric(exeMicros);
            if (this.profileStream != null) {
                this.profileStream.end(this.manager);
            }
        }
    }

    private void flushCommitAndNotify() throws SQLException {
        this.preCommit();
        this.performCommit();
        this.postCommit();
    }

    @Override
    public final void postCommit() {
        this.firePostCommit();
        this.notifyCommit();
    }

    @Override
    public final void preCommit() {
        this.internalBatchFlush();
        this.firePreCommit();
        this.internalBatchFlush();
    }

    public void commitAndContinue() {
        if (this.rollbackOnly) {
            return;
        }
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.flushCommitAndNotify();
            this.event = new TransactionEvent();
        }
        catch (Exception e) {
            this.doRollback(e);
            throw this.wrapIfNeeded(e);
        }
    }

    public void commit() {
        if (this.rollbackOnly) {
            this.rollback();
            return;
        }
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            if (this.queryOnly && !this.autoPersistUpdates) {
                this.connectionEndForQueryOnly();
            } else {
                this.flushCommitAndNotify();
            }
        }
        catch (Exception e) {
            this.doRollback(e);
            throw this.wrapIfNeeded(e);
        }
        finally {
            this.deactivate();
        }
    }

    private RuntimeException wrapIfNeeded(Exception e) {
        if (e instanceof PersistenceException) {
            return (PersistenceException)((Object)e);
        }
        return new RollbackException((Throwable)e);
    }

    final void notifyRollback(Throwable cause) {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfRollback(this, cause);
                this.logger.notifyRollback(cause);
            }
        }
    }

    public final boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public final void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public final boolean isNestedUseSavepoint() {
        return this.nestedUseSavepoint;
    }

    public final void setNestedUseSavepoint() {
        this.nestedUseSavepoint = true;
    }

    public void rollbackAndContinue() {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.internalBatchClear();
        if (this.changeLogHolder != null) {
            this.changeLogHolder.clear();
        }
        try {
            this.performRollback();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    public void rollback(Throwable cause) throws PersistenceException {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.doRollback(cause);
        }
        finally {
            this.deactivate();
        }
    }

    private void doRollback(Throwable cause) {
        this.internalBatchClear();
        this.firePreRollback();
        try {
            this.performRollback();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            this.postRollback(cause);
        }
    }

    @Override
    public final void postRollback(Throwable cause) {
        this.firePostRollback();
        this.notifyRollback(cause);
    }

    public void end() throws PersistenceException {
        if (this.active) {
            this.rollback();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void deactivateExternal() {
        this.active = false;
    }

    @Override
    public final boolean isPersistCascade() {
        return this.persistCascade;
    }

    public final void setPersistCascade(boolean persistCascade) {
        this.persistCascade = persistCascade;
    }

    public final void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.event().add(tableName, inserts, updates, deletes);
    }

    public final void putUserObject(String name, Object value) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, value);
    }

    public final Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    public final void close() {
        this.end();
    }
}

