/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import io.ebean.core.type.ScalarTypeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

final class ScalarTypeTimestamp
extends ScalarTypeBaseDateTime<Timestamp> {
    ScalarTypeTimestamp(JsonConfig.DateTime mode) {
        super(mode, Timestamp.class, true, 93);
    }

    protected String toJsonNanos(Timestamp value) {
        return String.valueOf(value.getTime());
    }

    protected String toJsonISO8601(Timestamp value) {
        return ScalarTypeUtils.formatInstant((Instant)value.toInstant());
    }

    public long convertToMillis(Timestamp value) {
        return value.getTime();
    }

    public Timestamp convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis);
    }

    public Timestamp convertFromTimestamp(Timestamp ts) {
        return ts;
    }

    public Timestamp convertFromInstant(Instant ts) {
        return Timestamp.from(ts);
    }

    public Timestamp convertToTimestamp(Timestamp t) {
        return t;
    }

    public void bind(DataBinder binder, Timestamp value) throws SQLException {
        if (value == null) {
            binder.setNull(93);
        } else {
            binder.setTimestamp(value);
        }
    }

    public Timestamp read(DataReader reader) throws SQLException {
        return reader.getTimestamp();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toTimestamp((Object)value);
    }

    public Timestamp toBeanType(Object value) {
        return BasicTypeConverter.toTimestamp((Object)value);
    }
}

