/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.ScalarTypeBaseDate;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

final class ScalarTypeYearMonthDate
extends ScalarTypeBaseDate<YearMonth> {
    ScalarTypeYearMonthDate(JsonConfig.Date mode) {
        super(mode, YearMonth.class, false, 91);
    }

    protected String toIsoFormat(YearMonth value) {
        return value.atDay(1).toString();
    }

    LocalDate toLocalDate(YearMonth yearMonth) {
        return yearMonth.atDay(1);
    }

    YearMonth fromLocalDate(LocalDate localDate) {
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    public YearMonth convertFromMillis(long systemTimeMillis) {
        return this.fromLocalDate(new Timestamp(systemTimeMillis).toLocalDateTime().toLocalDate());
    }

    public long convertToMillis(YearMonth value) {
        ZonedDateTime zonedDateTime = value.atDay(1).atStartOfDay(ZoneOffset.UTC);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public YearMonth convertFromDate(Date ts) {
        return this.fromLocalDate(ts.toLocalDate());
    }

    public Date convertToDate(YearMonth t) {
        return Date.valueOf(this.toLocalDate(t));
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof YearMonth) {
            return Date.valueOf(this.toLocalDate((YearMonth)value));
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        return BasicTypeConverter.toDate((Object)value);
    }

    public YearMonth toBeanType(Object value) {
        if (value instanceof YearMonth) {
            return (YearMonth)value;
        }
        if (value instanceof LocalDate) {
            return this.fromLocalDate((LocalDate)value);
        }
        if (value == null) {
            return null;
        }
        return this.fromLocalDate(BasicTypeConverter.toDate((Object)value).toLocalDate());
    }
}

