/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.DatabaseBuilder;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheFactory;
import io.ebeaninternal.server.cluster.ClusterManager;

public final class CacheManagerOptions {
    private final ClusterManager clusterManager;
    private final DatabaseBuilder.Settings databaseBuilder;
    private final boolean localL2Caching;
    private CurrentTenantProvider currentTenantProvider;
    private QueryCacheEntryValidate queryCacheEntryValidate;
    private ServerCacheFactory cacheFactory = new DefaultServerCacheFactory();
    private ServerCacheOptions beanDefault = new ServerCacheOptions();
    private ServerCacheOptions queryDefault = new ServerCacheOptions();

    CacheManagerOptions() {
        this.localL2Caching = true;
        this.clusterManager = null;
        this.databaseBuilder = null;
        this.cacheFactory = new DefaultServerCacheFactory();
        this.beanDefault = new ServerCacheOptions();
        this.queryDefault = new ServerCacheOptions();
    }

    public CacheManagerOptions(ClusterManager clusterManager, DatabaseBuilder.Settings config, boolean localL2Caching) {
        this.clusterManager = clusterManager;
        this.databaseBuilder = config;
        this.localL2Caching = localL2Caching;
        this.currentTenantProvider = config.getCurrentTenantProvider();
    }

    public CacheManagerOptions with(ServerCacheOptions beanDefault, ServerCacheOptions queryDefault) {
        this.beanDefault = beanDefault;
        this.queryDefault = queryDefault;
        return this;
    }

    public CacheManagerOptions with(ServerCacheFactory cacheFactory, QueryCacheEntryValidate queryCacheEntryValidate) {
        this.cacheFactory = cacheFactory;
        this.queryCacheEntryValidate = queryCacheEntryValidate;
        return this;
    }

    public CacheManagerOptions with(CurrentTenantProvider currentTenantProvider) {
        this.currentTenantProvider = currentTenantProvider;
        return this;
    }

    public String getServerName() {
        return this.databaseBuilder == null ? "db" : this.databaseBuilder.getName();
    }

    public boolean isLocalL2Caching() {
        return this.localL2Caching;
    }

    public ServerCacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public ServerCacheOptions getBeanDefault() {
        return this.beanDefault;
    }

    public ServerCacheOptions getQueryDefault() {
        return this.queryDefault;
    }

    public CurrentTenantProvider getCurrentTenantProvider() {
        return this.currentTenantProvider;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public QueryCacheEntryValidate getQueryCacheEntryValidate() {
        return this.queryCacheEntryValidate;
    }
}

