/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.FetchGroupBuilder;
import io.ebeaninternal.server.query.DFetchGroup;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.SpiFetchGroup;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class DFetchGroupBuilder<T>
implements FetchGroupBuilder<T> {
    private static final FetchConfig DEFAULT_FETCH = FetchConfig.ofDefault();
    private static final FetchConfig FETCH_CACHE = FetchConfig.ofCache();
    private static final FetchConfig FETCH_QUERY = FetchConfig.ofQuery();
    private static final FetchConfig FETCH_LAZY = FetchConfig.ofLazy();
    private final OrmQueryDetail detail = new OrmQueryDetail();

    DFetchGroupBuilder() {
    }

    public FetchGroupBuilder<T> select(String select) {
        this.detail.select(select);
        return this;
    }

    public FetchGroupBuilder<T> fetch(String path) {
        this.detail.fetchProperties(path, (Set<String>)null, DEFAULT_FETCH);
        return this;
    }

    public FetchGroupBuilder<T> fetch(String path, FetchGroup<?> nestedGroup) {
        return this.fetchNested(path, nestedGroup, DEFAULT_FETCH);
    }

    public FetchGroupBuilder<T> fetchQuery(String path, FetchGroup<?> nestedGroup) {
        return this.fetchNested(path, nestedGroup, FETCH_QUERY);
    }

    public FetchGroupBuilder<T> fetchLazy(String path, FetchGroup<?> nestedGroup) {
        return this.fetchNested(path, nestedGroup, FETCH_LAZY);
    }

    private FetchGroupBuilder<T> fetchNested(String path, FetchGroup<?> nestedGroup, FetchConfig fetchConfig) {
        OrmQueryDetail nestedDetail = ((SpiFetchGroup)nestedGroup).underlying();
        this.detail.addNested(path, nestedDetail, fetchConfig);
        return this;
    }

    public FetchGroupBuilder<T> fetchQuery(String path) {
        this.detail.fetchProperties(path, (Set<String>)null, FETCH_QUERY);
        return this;
    }

    public FetchGroupBuilder<T> fetchCache(String path) {
        this.detail.fetchProperties(path, (Set<String>)null, FETCH_CACHE);
        return this;
    }

    public FetchGroupBuilder<T> fetchLazy(String path) {
        this.detail.fetchProperties(path, (Set<String>)null, FETCH_LAZY);
        return this;
    }

    public FetchGroupBuilder<T> fetch(String path, String properties) {
        this.detail.fetch(path, properties, DEFAULT_FETCH);
        return this;
    }

    public FetchGroupBuilder<T> fetchQuery(String path, String properties) {
        this.detail.fetch(path, properties, FETCH_QUERY);
        return this;
    }

    public FetchGroupBuilder<T> fetchCache(String path, String properties) {
        this.detail.fetch(path, properties, FETCH_CACHE);
        return this;
    }

    public FetchGroupBuilder<T> fetchLazy(String path, String properties) {
        this.detail.fetch(path, properties, FETCH_LAZY);
        return this;
    }

    public FetchGroup<T> build() {
        return new DFetchGroup(this.detail);
    }
}

