/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.QueryIterator;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.DtoQueryRequest;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.DtoQueryIterator;
import jakarta.persistence.PersistenceException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class DtoQueryEngine {
    private final Binder binder;
    private final int defaultFetchSizeFindEach;
    private final int defaultFetchSizeFindList;

    public DtoQueryEngine(Binder binder, int defaultFetchSizeFindEach, int defaultFetchSizeFindList) {
        this.binder = binder;
        this.defaultFetchSizeFindEach = defaultFetchSizeFindEach;
        this.defaultFetchSizeFindList = defaultFetchSizeFindList;
    }

    public <T> List<T> findList(DtoQueryRequest<T> request) {
        try {
            if (this.defaultFetchSizeFindList > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindList);
            }
            request.executeSql(this.binder, SpiQuery.Type.LIST);
            ArrayList<T> rows = new ArrayList<T>();
            while (request.next()) {
                rows.add(request.readNextBean());
            }
            ArrayList<T> arrayList = rows;
            return arrayList;
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    public <T> QueryIterator<T> findIterate(DtoQueryRequest<T> request) {
        try {
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            return new DtoQueryIterator<T>(request);
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
    }

    public <T> void findEach(DtoQueryRequest<T> request, Consumer<T> consumer) {
        try {
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next()) {
                consumer.accept(request.readNextBean());
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    public <T> void findEach(DtoQueryRequest<T> request, int batchSize, Consumer<List<T>> consumer) {
        try {
            ArrayList<T> buffer = new ArrayList<T>();
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next()) {
                buffer.add(request.readNextBean());
                if (buffer.size() < batchSize) continue;
                consumer.accept(buffer);
                buffer.clear();
            }
            if (!buffer.isEmpty()) {
                consumer.accept(buffer);
            }
        }
        catch (Exception e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    public <T> void findEachWhile(DtoQueryRequest<T> request, Predicate<T> consumer) {
        try {
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            request.executeSql(this.binder, SpiQuery.Type.ITERATE);
            while (request.next() && consumer.test(request.readNextBean())) {
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(this.errMsg(e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    private String errMsg(String msg, String sql) {
        return "Query threw SQLException:" + msg + " Query was:" + sql;
    }
}

