/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.avaje.applog.AppLog;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebeaninternal.server.transaction.RemoteTableMod;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class TableModState
implements QueryCacheEntryValidate,
ServerCacheNotify {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.cache.TABLEMOD");
    private final Map<String, Instant> tableModStamp = new ConcurrentHashMap<String, Instant>();

    void touch(Set<String> touchedTables) {
        Instant modTime = Instant.now();
        for (String tableName : touchedTables) {
            this.tableModStamp.put(tableName, modTime);
        }
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "TableModState updated - touched:{0} modTime:{1}", touchedTables, modTime);
        }
    }

    boolean isValid(Set<String> tables, Instant sinceTime) {
        for (String tableName : tables) {
            Instant modTime = this.tableModStamp.get(tableName);
            if (modTime == null || modTime.isBefore(sinceTime)) continue;
            if (log.isLoggable(System.Logger.Level.TRACE)) {
                log.log(System.Logger.Level.TRACE, "Invalidate on table:{0}", tableName);
            }
            return false;
        }
        return true;
    }

    public boolean isValid(QueryCacheEntry entry) {
        Set dependentTables = entry.dependentTables();
        if (dependentTables != null && !dependentTables.isEmpty()) {
            return this.isValid(dependentTables, entry.timestamp());
        }
        return true;
    }

    public void notify(ServerCacheNotification notification) {
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "ServerCacheNotification:{0}", notification);
        }
        this.touch(notification.getDependentTables());
    }

    public void notify(RemoteTableMod tableMod) {
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "RemoteTableMod:{0}", tableMod);
        }
        this.touch(tableMod.getTables());
    }
}

