/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.CacheMode;
import io.ebean.Query;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.LoadBeanBuffer;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LoadBeanRequest
extends LoadRequest {
    private final Set<EntityBeanIntercept> batch;
    private final LoadBeanBuffer loadBuffer;
    private final String lazyLoadProperty;
    private final boolean loadCache;
    private final boolean alreadyLoaded;
    private String triggerEbi;
    private String batchBefore;
    private List<Object> queryIds;

    public LoadBeanRequest(LoadBeanBuffer loadBuffer, EntityBeanIntercept ebi, boolean loadCache) {
        this(loadBuffer, null, true, ebi.lazyLoadProperty(), ebi.isLoaded(), loadCache || ebi.isLoadedFromCache());
        this.triggerEbi = String.valueOf(ebi);
    }

    public LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest) {
        this(loadBuffer, parentRequest, false, null, false, false);
    }

    private LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest, boolean lazy, String lazyLoadProperty, boolean alreadyLoaded, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadBuffer = loadBuffer;
        this.batch = loadBuffer.batch();
        this.lazyLoadProperty = lazyLoadProperty;
        this.alreadyLoaded = alreadyLoaded;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> beanType() {
        return this.loadBuffer.descriptor().type();
    }

    public String description() {
        return this.loadBuffer.fullPath();
    }

    public boolean checkEmpty() {
        this.loadBuffer.loadingStarted();
        this.batchBefore = String.valueOf(this.batch);
        this.queryIds = this.ids();
        return this.batch.isEmpty();
    }

    private List<Object> ids() {
        ArrayList<Object> idList = new ArrayList<Object>(this.batch.size());
        BeanDescriptor<?> desc = this.loadBuffer.descriptor();
        for (EntityBeanIntercept ebi : this.batch) {
            idList.add(desc.getId(ebi.owner()));
        }
        return idList;
    }

    public SpiQuery<?> createQuery(SpiEbeanServer server) {
        Query query = server.createQuery((Class)this.beanType());
        query.usingTransaction(this.transaction);
        this.configureQuery((SpiQuery<?>)query);
        return query;
    }

    private void configureQuery(SpiQuery<?> query) {
        query.setMode(SpiQuery.Mode.LAZYLOAD_BEAN);
        query.setPersistenceContext(this.loadBuffer.persistenceContext());
        query.setLoadDescription(this.mode(), this.description());
        if (this.lazy) {
            query.setLazyLoadBatchSize(this.loadBuffer.batchSize());
            if (this.alreadyLoaded) {
                query.setBeanCacheMode(CacheMode.OFF);
            }
        } else {
            query.setBeanCacheMode(CacheMode.OFF);
        }
        this.loadBuffer.configureQuery(query, this.lazyLoadProperty);
        if (this.loadCache) {
            query.setBeanCacheMode(CacheMode.PUT);
        }
        if (this.queryIds.size() == 1) {
            query.where().idEq(this.queryIds.get(0));
        } else {
            query.where().idIn(this.queryIds);
        }
    }

    private String mode() {
        return this.lazy ? "lazy" : (this.loadBuffer.isCache() ? "cache" : "query");
    }

    public void postLoad(List<?> list) {
        this.loadBuffer.loadingStopped();
        HashSet<Object> loadedIds = new HashSet<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.descriptor();
        for (Object bean : list) {
            loadedIds.add(desc.id(bean));
        }
        if (this.loadCache) {
            desc.cacheBeanPutAll(list);
        }
        if (this.lazyLoadProperty != null) {
            ArrayList<EntityBeanIntercept> missed = new ArrayList<EntityBeanIntercept>();
            HashSet<Object> missedIds = new HashSet<Object>();
            for (EntityBeanIntercept ebi : this.batch) {
                Object id = desc.getId(ebi.owner());
                if (!loadedIds.contains(id)) {
                    if (this.queryIds.contains(id)) {
                        desc.markAsDeleted(ebi.owner());
                    } else {
                        missedIds.add(id);
                        missed.add(ebi);
                    }
                }
                if (missed.isEmpty() || !CoreLog.markedAsDeleted.isLoggable(System.Logger.Level.DEBUG)) continue;
                CoreLog.markedAsDeleted.log(System.Logger.Level.DEBUG, "Loaded bean batch triggered by ebi:{0} property:{1}", this.triggerEbi, this.lazyLoadProperty);
                CoreLog.markedAsDeleted.log(System.Logger.Level.DEBUG, "Loaded bean batch BEFORE {0}", this.batchBefore);
                CoreLog.markedAsDeleted.log(System.Logger.Level.DEBUG, "Loaded bean batch AFTER {0}", this.batch);
                String msg = MessageFormat.format("Bean added to batch during load for {0} missedIds:{1} queryIds:{2} missed:{3}", this.beanType(), missedIds, this.queryIds, missed);
                CoreLog.markedAsDeleted.log(System.Logger.Level.DEBUG, msg, (Throwable)new RuntimeException("LoadBeanRequest - Bean added to batch during load"));
            }
        }
    }
}

