/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.config.BackgroundExecutorWrapper;
import io.ebean.config.ContainerConfig;
import io.ebean.config.DatabaseConfigProvider;
import io.ebean.config.EntityClassRegister;
import io.ebean.config.NamingConvention;
import io.ebean.config.TenantMode;
import io.ebean.config.UnderscoreNamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.event.ShutdownManager;
import io.ebean.service.SpiContainer;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.core.DatabasePlatformFactory;
import io.ebeaninternal.server.core.DefaultServer;
import io.ebeaninternal.server.core.InitDataSource;
import io.ebeaninternal.server.core.InternalConfiguration;
import io.ebeaninternal.server.core.bootup.BootupClassPathSearch;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.executor.DefaultBackgroundExecutor;
import jakarta.persistence.PersistenceException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class DefaultContainer
implements SpiContainer {
    private static final System.Logger log = CoreLog.log;
    private final ReentrantLock lock = new ReentrantLock();
    private final ClusterManager clusterManager;
    private final List<EntityClassRegister> entityClassRegisters;

    public DefaultContainer(ContainerConfig containerConfig) {
        this.clusterManager = new ClusterManager(containerConfig);
        ShutdownManager.registerContainer((SpiContainer)this);
        this.entityClassRegisters = this.initEntityRegisters();
    }

    private List<EntityClassRegister> initEntityRegisters() {
        ArrayList<EntityClassRegister> entityClassRegisters = new ArrayList<EntityClassRegister>();
        for (EntityClassRegister entityClassRegister : ServiceLoader.load(EntityClassRegister.class)) {
            entityClassRegisters.add(entityClassRegister);
        }
        return entityClassRegisters;
    }

    public void shutdown() {
        this.clusterManager.shutdown();
        ShutdownManager.shutdown();
    }

    public SpiEbeanServer createServer(String name) {
        DatabaseBuilder builder = Database.builder().name(name).loadFromProperties();
        return this.createServer(builder);
    }

    private SpiBackgroundExecutor createBackgroundExecutor(DatabaseBuilder builder) {
        DatabaseBuilder.Settings config = builder.settings();
        String namePrefix = "ebean-" + config.getName();
        int schedulePoolSize = config.getBackgroundExecutorSchedulePoolSize();
        int shutdownSecs = config.getBackgroundExecutorShutdownSecs();
        BackgroundExecutorWrapper wrapper = config.getBackgroundExecutorWrapper();
        return new DefaultBackgroundExecutor(schedulePoolSize, shutdownSecs, namePrefix, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiEbeanServer createServer(DatabaseBuilder builder) {
        this.lock.lock();
        try {
            DatabaseBuilder.Settings config = builder.settings();
            long start = System.currentTimeMillis();
            this.applyConfigServices(config);
            this.setNamingConvention(config);
            BootupClasses bootupClasses = this.bootupClasses(config);
            boolean online = true;
            TenantMode tenantMode = config.getTenantMode();
            if (TenantMode.DB != tenantMode) {
                this.setDataSource(config);
                if (!tenantMode.isDynamicDataSource()) {
                    online = this.checkDataSource(config);
                }
            }
            this.setDatabasePlatform(config);
            if (config.getDbEncrypt() != null) {
                config.getDatabasePlatform().setDbEncrypt(config.getDbEncrypt());
            }
            config.getNamingConvention().setDatabasePlatform(config.getDatabasePlatform());
            SpiBackgroundExecutor executor = this.createBackgroundExecutor((DatabaseBuilder)config);
            InternalConfiguration c = new InternalConfiguration(online, this.clusterManager, executor, config, bootupClasses);
            DefaultServer server = new DefaultServer(c, c.cacheManager());
            if (!DbOffline.isGenerateMigration()) {
                this.startServer(online, server);
            }
            DbOffline.reset();
            log.log(System.Logger.Level.INFO, "Started database[{0}] platform[{1}] in {2}ms", config.getName(), config.getDatabasePlatform().platform(), System.currentTimeMillis() - start);
            DefaultServer defaultServer = server;
            return defaultServer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void applyConfigServices(DatabaseBuilder.Settings config) {
        if (config.isDefaultServer()) {
            for (DatabaseConfigProvider configProvider : ServiceLoader.load(DatabaseConfigProvider.class)) {
                configProvider.apply((DatabaseBuilder)config);
            }
        }
        if (config.isLoadModuleInfo()) {
            for (EntityClassRegister loader : this.entityClassRegisters) {
                config.addAll((Collection)loader.classesFor(config.getName(), config.isDefaultServer()));
            }
            if (this.entityClassRegisters.isEmpty()) {
                this.checkMissingModulePathProvides();
            }
        }
    }

    private void checkMissingModulePathProvides() {
        URL servicesFile = ClassLoader.getSystemResource("META-INF/services/io.ebean.config.EntityClassRegister");
        if (servicesFile != null) {
            log.log(System.Logger.Level.ERROR, "module-info.java is probably missing ''provides io.ebean.config.EntityClassRegister with EbeanEntityRegister'' clause. EntityClassRegister exists but was not service loaded.");
        }
    }

    private void startServer(boolean online, DefaultServer server) {
        server.executePlugins(online);
        server.initialise();
        if (online && this.clusterManager.isClustering()) {
            this.clusterManager.registerServer((Database)server);
        }
        server.start();
    }

    private BootupClasses bootupClasses(DatabaseBuilder.Settings config) {
        BootupClasses bootup = this.bootupClasses1(config);
        bootup.addServerConfigStartup(config.getServerConfigStartupListeners());
        bootup.runServerConfigStartup((DatabaseBuilder)config);
        bootup.addIdGenerators(config.getIdGenerators());
        bootup.addPersistControllers(config.getPersistControllers());
        bootup.addPostLoaders(config.getPostLoaders());
        bootup.addPostConstructListeners(config.getPostConstructListeners());
        bootup.addFindControllers(config.getFindControllers());
        bootup.addPersistListeners(config.getPersistListeners());
        bootup.addQueryAdapters(config.getQueryAdapters());
        bootup.addChangeLogInstances(config);
        return bootup;
    }

    private BootupClasses bootupClasses1(DatabaseBuilder.Settings config) {
        Set classes = config.classes();
        if (config.isDisableClasspathSearch() || classes != null && !classes.isEmpty()) {
            return new BootupClasses(classes);
        }
        return BootupClassPathSearch.search(config);
    }

    private void setNamingConvention(DatabaseBuilder.Settings config) {
        if (config.getNamingConvention() == null) {
            config.namingConvention((NamingConvention)new UnderscoreNamingConvention());
        }
    }

    private void setDatabasePlatform(DatabaseBuilder.Settings config) {
        DatabasePlatform platform = config.getDatabasePlatform();
        if (platform == null) {
            if (config.getTenantMode().isDynamicDataSource()) {
                throw new IllegalStateException("DatabasePlatform must be explicitly set on DatabaseConfig for TenantMode " + String.valueOf(config.getTenantMode()));
            }
            platform = new DatabasePlatformFactory().create(config);
            config.databasePlatform(platform);
        }
        platform.configure(config.getPlatformConfig());
    }

    private void setDataSource(DatabaseBuilder.Settings config) {
        if (this.isOfflineMode(config)) {
            log.log(System.Logger.Level.DEBUG, "... DbOffline using platform [{0}]", DbOffline.getPlatform());
        } else {
            InitDataSource.init(config);
        }
    }

    private boolean isOfflineMode(DatabaseBuilder.Settings config) {
        return config.isDbOffline() || DbOffline.isSet();
    }

    private boolean checkDataSource(DatabaseBuilder.Settings config) {
        boolean bl;
        block13: {
            if (this.isOfflineMode(config)) {
                return false;
            }
            if (config.getDataSource() == null) {
                if (config.getDataSourceConfig().isOffline()) {
                    return false;
                }
                throw new RuntimeException("DataSource not set?");
            }
            if (config.skipDataSourceCheck()) {
                return true;
            }
            Connection connection = config.getDataSource().getConnection();
            try {
                if (connection.getAutoCommit()) {
                    log.log(System.Logger.Level.WARNING, "DataSource [{0}] has autoCommit defaulting to true!", config.getName());
                }
                bl = true;
                if (connection == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
            connection.close();
        }
        return bl;
    }
}

