/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.deploy.IntersectionTable;
import java.util.ArrayList;
import java.util.List;

public final class IntersectionBuilder {
    private final String table;
    private final List<String> columns = new ArrayList<String>();

    IntersectionBuilder(String table) {
        this.table = table;
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    public IntersectionTable build() {
        String insertSql = this.insertSql(this.table);
        String deleteSql = this.deleteSql(this.table);
        return new IntersectionTable(insertSql, deleteSql);
    }

    private String insertSql(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(tableName).append(" (");
        int count = 0;
        for (String column : this.columns) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(") values (");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        sb.append(')');
        return sb.toString();
    }

    private String deleteSql(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(tableName);
        sb.append(" where ");
        int count = 0;
        for (String column : this.columns) {
            if (count++ > 0) {
                sb.append(" and ");
            }
            sb.append(column);
            sb.append(" = ?");
        }
        return sb.toString();
    }
}

