/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.generatedproperty;

import io.ebeaninternal.server.deploy.generatedproperty.GeneratedCounter;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedCounterInteger;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedCounterLong;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class CounterFactory {
    private final GeneratedCounterInteger integerCounter = new GeneratedCounterInteger();
    private final GeneratedCounterLong longCounter = new GeneratedCounterLong();

    CounterFactory() {
    }

    void setCounter(DeployBeanProperty property) {
        property.setGeneratedProperty(this.createCounter(property));
    }

    private GeneratedProperty createCounter(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        if (propType.equals(Integer.class) || propType.equals(Integer.TYPE)) {
            return this.integerCounter;
        }
        if (propType.equals(Long.class) || propType.equals(Long.TYPE)) {
            return this.longCounter;
        }
        int type = this.getType(propType);
        return new GeneratedCounter(type);
    }

    private int getType(Class<?> propType) {
        if (propType.equals(Short.class) || propType.equals(Short.TYPE)) {
            return -6;
        }
        if (propType.equals(BigDecimal.class)) {
            return 3;
        }
        if (propType.equals(Double.class) || propType.equals(Double.TYPE)) {
            return 8;
        }
        if (propType.equals(Float.class) || propType.equals(Float.TYPE)) {
            return 7;
        }
        if (propType.equals(BigInteger.class)) {
            return -5;
        }
        String msg = "Can not support Counter for type " + propType.getName();
        throw new PersistenceException(msg);
    }
}

