/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.visitor;

import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.visitor.BeanPropertyVisitor;

public class VisitProperties {
    public static void visit(BeanDescriptor<?> descriptor, BeanPropertyVisitor visitor) {
        new VisitProperties().visitProperties(descriptor, visitor);
    }

    protected void visitProperties(BeanDescriptor<?> desc, BeanPropertyVisitor propertyVisitor) {
        BeanPropertyAssocOne<?> unidirectional;
        BeanProperty idProp = desc.idProperty();
        if (idProp != null && !idProp.name().equals("_$IdClass$")) {
            this.visit(propertyVisitor, idProp);
        }
        if ((unidirectional = desc.unidirectional()) != null) {
            this.visit(propertyVisitor, unidirectional);
        }
        for (BeanProperty p : desc.propertiesNonTransient()) {
            if (!p.isDDLColumn()) continue;
            this.visit(propertyVisitor, p);
        }
        propertyVisitor.visitEnd();
    }

    protected void visit(BeanPropertyVisitor pv, BeanProperty p) {
        if (p instanceof BeanPropertyAssocMany) {
            pv.visitMany((BeanPropertyAssocMany)p);
        } else if (p instanceof BeanPropertyAssocOne) {
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)p;
            if (assocOne.isEmbedded()) {
                BeanProperty[] embProps;
                pv.visitEmbedded(assocOne);
                for (BeanProperty embProp : embProps = assocOne.properties()) {
                    pv.visitEmbeddedScalar(embProp, assocOne);
                }
            } else if (assocOne.isOneToOneExported()) {
                pv.visitOneExported(assocOne);
            } else {
                pv.visitOneImported(assocOne);
            }
        } else {
            pv.visitScalar(p, true);
        }
    }
}

