/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import io.ebean.core.type.ScalarTypeUtils;
import io.ebeaninternal.server.type.ScalarHelp;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Duration;

class ScalarTypeDuration
extends ScalarTypeBase<Duration> {
    ScalarTypeDuration() {
        super(Duration.class, false, -5);
    }

    ScalarTypeDuration(int jdbcType) {
        super(Duration.class, false, jdbcType);
    }

    BigDecimal convertToBigDecimal(Duration value) {
        return value == null ? null : ScalarTypeUtils.toDecimal((Duration)value);
    }

    Duration convertFromBigDecimal(BigDecimal value) {
        return value == null ? null : ScalarTypeUtils.toDuration((BigDecimal)value);
    }

    public void bind(DataBinder binder, Duration value) throws SQLException {
        if (value == null) {
            binder.setNull(-5);
        } else {
            binder.setLong(value.getSeconds());
        }
    }

    public Duration read(DataReader reader) throws SQLException {
        Long value = reader.getLong();
        return value == null ? null : Duration.ofSeconds(value);
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Long) {
            return value;
        }
        return ((Duration)value).getSeconds();
    }

    public Duration toBeanType(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value == null) {
            return null;
        }
        return Duration.ofSeconds(BasicTypeConverter.toLong((Object)value));
    }

    public Duration readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.convertFromBigDecimal(new BigDecimal(dataInput.readUTF()));
    }

    public void writeData(DataOutput dataOutput, Duration value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.convertToBigDecimal(value).toString());
        }
    }

    public String formatValue(Duration v) {
        return v.toString();
    }

    public Duration parse(String value) {
        return Duration.parse(value);
    }

    public Duration jsonRead(JsonParser parser) throws IOException {
        return Duration.parse(parser.getValueAsString());
    }

    public void jsonWrite(JsonGenerator writer, Duration value) throws IOException {
        writer.writeString(value.toString());
    }

    public DocPropertyType docType() {
        return DocPropertyType.KEYWORD;
    }
}

