/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import io.ebean.core.type.ScalarTypeUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;

final class ScalarTypeOffsetDateTime
extends ScalarTypeBaseDateTime<OffsetDateTime> {
    private final ZoneId zoneId;

    ScalarTypeOffsetDateTime(JsonConfig.DateTime mode, ZoneId zoneId) {
        super(mode, OffsetDateTime.class, false, 93);
        this.zoneId = zoneId;
    }

    protected String toJsonNanos(OffsetDateTime value) {
        return this.toJsonNanos(value.toEpochSecond(), value.getNano());
    }

    protected String toJsonISO8601(OffsetDateTime value) {
        return ScalarTypeUtils.formatInstant((Instant)value.toInstant());
    }

    public long convertToMillis(OffsetDateTime value) {
        return value.toInstant().toEpochMilli();
    }

    public OffsetDateTime convertFromMillis(long systemTimeMillis) {
        return this.convertFromInstant(Instant.ofEpochMilli(systemTimeMillis));
    }

    public OffsetDateTime convertFromTimestamp(Timestamp ts) {
        return this.convertFromInstant(ts.toInstant());
    }

    public OffsetDateTime convertFromInstant(Instant ts) {
        return OffsetDateTime.ofInstant(ts, this.zoneId);
    }

    public Timestamp convertToTimestamp(OffsetDateTime t) {
        return Timestamp.from(t.toInstant());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((OffsetDateTime)value);
    }

    public OffsetDateTime toBeanType(Object value) {
        if (value instanceof Timestamp) {
            return this.convertFromTimestamp((Timestamp)value);
        }
        return (OffsetDateTime)value;
    }
}

