/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdate;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanManager;
import io.ebeaninternal.server.persist.PersistExecute;

public final class PersistRequestOrmUpdate
extends PersistRequest {
    private final BeanDescriptor<?> beanDescriptor;
    private final SpiUpdate<?> ormUpdate;
    private int rowCount;
    private String bindLog;

    public PersistRequestOrmUpdate(SpiEbeanServer server, BeanManager<?> mgr, SpiUpdate<?> ormUpdate, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t, persistExecute, ormUpdate.label());
        this.beanDescriptor = mgr.getBeanDescriptor();
        this.ormUpdate = ormUpdate;
    }

    @Override
    public void profile(long offset, int flushCount) {
        this.profileBase("uo", offset, this.beanDescriptor.name(), flushCount);
    }

    public BeanDescriptor<?> descriptor() {
        return this.beanDescriptor;
    }

    @Override
    public int executeNow() {
        return this.persistExecute.executeOrmUpdate(this);
    }

    @Override
    public int executeOrQueue() {
        return this.executeStatement();
    }

    public SpiUpdate<?> ormUpdate() {
        return this.ormUpdate;
    }

    @Override
    public void checkRowCount(int count) {
        this.rowCount = count;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
    }

    public void setBindLog(String bindLog) {
        this.bindLog = bindLog;
    }

    @Override
    public void postExecute() {
        SpiUpdate.OrmUpdateType ormUpdateType = this.ormUpdate.ormUpdateType();
        if (SpiUpdate.OrmUpdateType.INSERT != ormUpdateType && !this.transaction.isAutoPersistUpdates()) {
            this.beanDescriptor.contextClear(this.transaction.persistenceContext());
        }
        if (this.startNanos > 0L) {
            this.persistExecute.collectOrmUpdate(this.label, this.startNanos);
        }
        String tableName = this.ormUpdate.baseTable();
        if (this.transaction.isLogSummary()) {
            this.transaction.logSummary("{0} table[{1}] rows[{2}] bind[{3}]", new Object[]{ormUpdateType, tableName, this.rowCount, this.bindLog});
        }
        if (this.ormUpdate.isNotifyCache()) {
            switch (ormUpdateType) {
                case INSERT: {
                    this.transaction.event().add(tableName, true, false, false);
                    break;
                }
                case UPDATE: {
                    this.transaction.event().add(tableName, false, true, false);
                    break;
                }
                case DELETE: {
                    this.transaction.event().add(tableName, false, false, true);
                    break;
                }
            }
        }
    }
}

