/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.avaje.applog.AppLog;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.cache.ServerCache;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiCacheControl;
import io.ebeaninternal.api.SpiCacheRegion;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedBeanDataFromBean;
import io.ebeaninternal.server.cache.CachedBeanDataToBean;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.ebeaninternal.server.cache.SpiCacheManager;
import io.ebeaninternal.server.core.CacheOptions;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanCollectionUtil;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DCacheControl;
import io.ebeaninternal.server.deploy.DCacheControlNone;
import io.ebeaninternal.server.deploy.DCacheRegionNone;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class BeanDescriptorCacheHelp<T> {
    private static final System.Logger log = CoreLog.internal;
    private static final System.Logger queryLog = AppLog.getLogger((String)"io.ebean.cache.QUERY");
    private static final System.Logger beanLog = AppLog.getLogger((String)"io.ebean.cache.BEAN");
    private static final System.Logger manyLog = AppLog.getLogger((String)"io.ebean.cache.COLL");
    private static final System.Logger natLog = AppLog.getLogger((String)"io.ebean.cache.NATKEY");
    private final BeanDescriptor<T> desc;
    private final SpiCacheManager cacheManager;
    private final CacheOptions cacheOptions;
    private final boolean cacheSharableBeans;
    private final boolean invalidateQueryCache;
    private final Class<?> beanType;
    private final String cacheName;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final String[] naturalKey;
    private final ServerCache beanCache;
    private final ServerCache naturalKeyCache;
    private final ServerCache queryCache;
    private final boolean noCaching;
    private final SpiCacheControl cacheControl;
    private final SpiCacheRegion cacheRegion;
    private boolean cacheNotifyOnAll;
    private boolean cacheNotifyOnDelete;

    BeanDescriptorCacheHelp(BeanDescriptor<T> desc, SpiCacheManager cacheManager, CacheOptions cacheOptions, boolean cacheSharableBeans, BeanPropertyAssocOne<?>[] propertiesOneImported) {
        this.desc = desc;
        this.beanType = desc.rootBeanType;
        this.cacheName = this.beanType.getSimpleName();
        this.cacheManager = cacheManager;
        this.cacheOptions = cacheOptions;
        this.invalidateQueryCache = cacheOptions.isInvalidateQueryCache();
        this.cacheSharableBeans = cacheSharableBeans;
        this.propertiesOneImported = propertiesOneImported;
        this.naturalKey = cacheOptions.getNaturalKey();
        this.queryCache = !cacheOptions.isEnableQueryCache() ? null : cacheManager.getQueryCache(this.beanType);
        if (cacheOptions.isEnableBeanCache()) {
            this.beanCache = cacheManager.getBeanCache(this.beanType);
            this.naturalKeyCache = cacheOptions.getNaturalKey() != null ? cacheManager.getNaturalKeyCache(this.beanType) : null;
        } else {
            this.beanCache = null;
            this.naturalKeyCache = null;
        }
        boolean bl = this.noCaching = this.beanCache == null && this.queryCache == null;
        if (this.noCaching) {
            this.cacheControl = DCacheControlNone.INSTANCE;
            this.cacheRegion = this.invalidateQueryCache ? cacheManager.getRegion(cacheOptions.getRegion()) : DCacheRegionNone.INSTANCE;
        } else {
            this.cacheRegion = cacheManager.getRegion(cacheOptions.getRegion());
            this.cacheControl = new DCacheControl(this.cacheRegion, this.beanCache != null, this.naturalKeyCache != null, this.queryCache != null);
        }
    }

    void deriveNotifyFlags() {
        this.cacheNotifyOnAll = this.invalidateQueryCache || this.beanCache != null || this.queryCache != null;
        boolean bl = this.cacheNotifyOnDelete = !this.cacheNotifyOnAll && this.isNotifyOnDeletes();
        if (log.isLoggable(System.Logger.Level.DEBUG) && (this.cacheNotifyOnAll || this.cacheNotifyOnDelete)) {
            String notifyMode = this.cacheNotifyOnAll ? "All" : "Delete";
            log.log(System.Logger.Level.DEBUG, "l2 caching on {0} - beanCaching:{1} queryCaching:{2} notifyMode:{3} ", this.desc.fullName(), this.isBeanCaching(), this.isQueryCaching(), notifyMode);
        }
    }

    private boolean isNotifyOnDeletes() {
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            if (!imported.isCacheNotifyRelationship()) continue;
            return true;
        }
        return false;
    }

    boolean isCacheNotify(PersistRequest.Type type) {
        return this.cacheRegion.isEnabled() && (this.cacheNotifyOnAll || this.cacheNotifyOnDelete && (type == PersistRequest.Type.DELETE || type == PersistRequest.Type.DELETE_PERMANENT));
    }

    boolean isQueryCaching() {
        return this.cacheControl.isQueryCaching();
    }

    boolean isBeanCaching() {
        return this.cacheControl.isBeanCaching();
    }

    boolean isNaturalKeyCaching() {
        return this.cacheControl.isNaturalKeyCaching();
    }

    boolean isCaching() {
        return this.cacheControl.isCaching();
    }

    String[] getNaturalKey() {
        return this.naturalKey;
    }

    CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    void queryCacheClear() {
        if (this.queryCache != null) {
            if (queryLog.isLoggable(System.Logger.Level.DEBUG)) {
                queryLog.log(System.Logger.Level.DEBUG, "   CLEAR {0}", this.cacheName);
            }
            this.queryCache.clear();
        }
    }

    private void queryCacheClear(CacheChangeSet changeSet) {
        if (this.queryCache != null) {
            changeSet.addClearQuery(this.desc);
        }
    }

    Object queryCacheGet(Object id) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + String.valueOf(this.desc) + ". Need explicit @Cache(enableQueryCache=true)");
        }
        Object queryResult = this.queryCache.get(id);
        if (queryLog.isLoggable(System.Logger.Level.DEBUG)) {
            if (queryResult == null) {
                queryLog.log(System.Logger.Level.DEBUG, "   GET {0}({1}) - cache miss", this.cacheName, id);
            } else {
                queryLog.log(System.Logger.Level.DEBUG, "   GET {0}({1}) - hit", this.cacheName, id);
            }
        }
        return queryResult;
    }

    void queryCachePut(Object id, QueryCacheEntry entry) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + String.valueOf(this.desc) + ". Need explicit @Cache(enableQueryCache=true)");
        }
        if (queryLog.isLoggable(System.Logger.Level.DEBUG)) {
            queryLog.log(System.Logger.Level.DEBUG, "   PUT {0}({1})", this.cacheName, id);
        }
        this.queryCache.put(id, (Object)entry);
    }

    void manyPropRemove(String propertyName, String parentKey) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isLoggable(System.Logger.Level.TRACE)) {
            manyLog.log(System.Logger.Level.TRACE, "   REMOVE {0}({1}).{2}", this.cacheName, parentKey, propertyName);
        }
        collectionIdsCache.remove((Object)parentKey);
    }

    void manyPropClear(String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isLoggable(System.Logger.Level.DEBUG)) {
            manyLog.log(System.Logger.Level.DEBUG, "   CLEAR {0}(*).{1} ", this.cacheName, propertyName);
        }
        collectionIdsCache.clear();
    }

    private CachedManyIds manyPropGet(String propertyName, String parentKey) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        CachedManyIds entry = (CachedManyIds)collectionIdsCache.get((Object)parentKey);
        if (entry == null) {
            if (manyLog.isLoggable(System.Logger.Level.TRACE)) {
                manyLog.log(System.Logger.Level.TRACE, "   GET {0}({1}).{2} - cache miss", this.cacheName, parentKey, propertyName);
            }
        } else if (manyLog.isLoggable(System.Logger.Level.DEBUG)) {
            manyLog.log(System.Logger.Level.DEBUG, "   GET {0}({1}).{2} - hit", this.cacheName, parentKey, propertyName);
        }
        return entry;
    }

    boolean manyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, String parentKey, Boolean readOnly) {
        if (many.isElementCollection()) {
            return false;
        }
        CachedManyIds entry = this.manyPropGet(many.name(), parentKey);
        if (entry == null) {
            return false;
        }
        EntityBean ownerBean = bc.owner();
        EntityBeanIntercept ebi = ownerBean._ebean_getIntercept();
        PersistenceContext persistenceContext = ebi.persistenceContext();
        BeanDescriptor targetDescriptor = many.targetDescriptor();
        List<Object> idList = entry.getIdList();
        bc.checkEmptyLazyLoad();
        int i = 0;
        for (Object id : idList) {
            EntityBean ref = targetDescriptor.createReference(readOnly, id, persistenceContext);
            if (many.hasOrderColumn()) {
                ref._ebean_getIntercept().setSortOrder(++i);
            }
            many.add(bc, ref);
        }
        return true;
    }

    void manyPropPut(BeanPropertyAssocMany<?> many, Object details, String parentKey) {
        if (many.isElementCollection()) {
            CachedBeanData data = (CachedBeanData)this.beanCache.get((Object)parentKey);
            if (data != null) {
                try {
                    String asJson = many.jsonWriteCollection(details);
                    HashMap<String, Object> changes = new HashMap<String, Object>();
                    changes.put(many.name(), asJson);
                    CachedBeanData newData = data.update(changes, data.getVersion());
                    if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
                        beanLog.log(System.Logger.Level.DEBUG, "   UPDATE {0}({1})  changes:{2}", this.cacheName, parentKey, changes);
                    }
                    this.beanCache.put((Object)parentKey, (Object)newData);
                }
                catch (IOException e) {
                    log.log(System.Logger.Level.ERROR, "Error updating L2 cache", (Throwable)e);
                }
            }
        } else {
            CachedManyIds entry = this.createManyIds(many, details);
            if (entry != null) {
                this.cachePutManyIds(many.name(), parentKey, entry);
            }
        }
    }

    void cachePutManyIds(String manyName, String parentKey, CachedManyIds entry) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, manyName);
        if (manyLog.isLoggable(System.Logger.Level.DEBUG)) {
            manyLog.log(System.Logger.Level.DEBUG, "   PUT {0}({1}).{2} - ids:{3}", this.cacheName, parentKey, manyName, entry);
        }
        collectionIdsCache.put((Object)parentKey, (Object)entry);
    }

    private CachedManyIds createManyIds(BeanPropertyAssocMany<?> many, Object details) {
        Collection<?> actualDetails = BeanCollectionUtil.getActualDetails(details);
        if (actualDetails == null) {
            return null;
        }
        BeanDescriptor targetDescriptor = many.targetDescriptor();
        ArrayList<Object> idList = new ArrayList<Object>(actualDetails.size());
        for (Object bean : actualDetails) {
            idList.add(targetDescriptor.id(bean));
        }
        return new CachedManyIds(idList);
    }

    BeanCacheResult<T> cacheIdLookup(PersistenceContext context, Collection<?> ids) {
        HashSet<String> keys = new HashSet<String>(ids.size());
        for (Object id : ids) {
            keys.add(this.desc.cacheKey(id));
        }
        if (ids.isEmpty()) {
            return new BeanCacheResult();
        }
        Map beanDataMap = this.beanCache.getAll(keys);
        if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
            beanLog.log(System.Logger.Level.TRACE, "   MGET {0}({1}) - hits:{2}", this.cacheName, ids, beanDataMap.keySet());
        }
        BeanCacheResult<T> result = new BeanCacheResult<T>();
        for (Map.Entry entry : beanDataMap.entrySet()) {
            CachedBeanData cachedBeanData = (CachedBeanData)entry.getValue();
            T bean = this.convertToBean(entry.getKey(), false, context, cachedBeanData);
            result.add(bean, this.desc.id(bean));
        }
        return result;
    }

    BeanCacheResult<T> naturalKeyLookup(PersistenceContext context, Set<Object> keys) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        Map naturalKeyMap = this.naturalKeyCache.getAll(keys);
        if (natLog.isLoggable(System.Logger.Level.TRACE)) {
            natLog.log(System.Logger.Level.TRACE, " MLOOKUP {0}({1}) - hits:{2}", this.cacheName, keys, naturalKeyMap);
        }
        BeanCacheResult<T> result = new BeanCacheResult<T>();
        if (naturalKeyMap.isEmpty()) {
            return result;
        }
        HashMap reverseMap = new HashMap();
        for (Map.Entry entry : naturalKeyMap.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        HashSet ids = new HashSet(naturalKeyMap.values());
        Map beanDataMap = this.beanCache.getAll(ids);
        if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
            beanLog.log(System.Logger.Level.TRACE, "   MGET {0}({1}) - hits:{2}", this.cacheName, ids, beanDataMap.keySet());
        }
        for (Map.Entry entry : beanDataMap.entrySet()) {
            Object id = entry.getKey();
            CachedBeanData cachedBeanData = (CachedBeanData)entry.getValue();
            T bean = this.convertToBean(id, false, context, cachedBeanData);
            Object naturalKey = reverseMap.get(id);
            result.add(bean, naturalKey);
        }
        return result;
    }

    private void setupContext(Object bean, PersistenceContext context) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        EntityBean entityBean = (EntityBean)bean;
        EntityBeanIntercept ebi = entityBean._ebean_getIntercept();
        ebi.setPersistenceContext(context);
        Object id = this.desc.getId(entityBean);
        this.desc.contextPut(context, id, bean);
    }

    private ServerCache getBeanCache() {
        if (this.beanCache == null) {
            throw new IllegalStateException("No bean cache enabled for " + String.valueOf(this.desc) + ". Add the @Cache annotation.");
        }
        return this.beanCache;
    }

    void beanCacheClear() {
        if (this.beanCache != null) {
            if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
                beanLog.log(System.Logger.Level.DEBUG, "   CLEAR {0}", this.cacheName);
            }
            this.beanCache.clear();
        }
    }

    CachedBeanData beanExtractData(BeanDescriptor<?> targetDesc, EntityBean bean) {
        return CachedBeanDataFromBean.extract(targetDesc, bean);
    }

    void beanPutAll(Collection<EntityBean> beans) {
        this.beanCachePutAllDirect(beans);
    }

    void beanCachePutAllDirect(Collection<EntityBean> beans) {
        LinkedHashMap<String, String> natKeys = null;
        if (this.naturalKey != null) {
            natKeys = new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, CachedBeanData> map = new LinkedHashMap<String, CachedBeanData>();
        for (EntityBean bean : beans) {
            String naturalKey;
            CachedBeanData beanData = this.beanExtractData(this.desc, bean);
            String key = this.desc.cacheKeyForBean(bean);
            map.put(key, beanData);
            if (this.naturalKey == null || (naturalKey = this.calculateNaturalKey(beanData)) == null) continue;
            natKeys.put(naturalKey, key);
        }
        if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
            beanLog.log(System.Logger.Level.DEBUG, "   MPUT {0}({1})", this.cacheName, map.keySet());
        }
        this.getBeanCache().putAll(map);
        if (natKeys != null && !natKeys.isEmpty()) {
            if (natLog.isLoggable(System.Logger.Level.DEBUG)) {
                natLog.log(System.Logger.Level.DEBUG, " MPUT {0}({1}, {2})", this.cacheName, Arrays.toString(this.naturalKey), natKeys.keySet());
            }
            this.naturalKeyCache.putAll(natKeys);
        }
    }

    void beanCachePut(EntityBean bean) {
        this.beanCachePutDirect(bean);
    }

    void beanCachePutDirect(EntityBean bean) {
        String naturalKey;
        CachedBeanData beanData = this.beanExtractData(this.desc, bean);
        String key = this.desc.cacheKeyForBean(bean);
        if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
            beanLog.log(System.Logger.Level.DEBUG, "   PUT {0}({1}) data:{2}", this.cacheName, key, beanData);
        }
        this.getBeanCache().put((Object)key, (Object)beanData);
        if (this.naturalKey != null && (naturalKey = this.calculateNaturalKey(beanData)) != null) {
            if (natLog.isLoggable(System.Logger.Level.DEBUG)) {
                natLog.log(System.Logger.Level.DEBUG, " PUT {0}({1}, {2})", this.cacheName, naturalKey, key);
            }
            this.naturalKeyCache.put((Object)naturalKey, (Object)key);
        }
    }

    private String calculateNaturalKey(CachedBeanData beanData) {
        if (this.naturalKey.length == 1) {
            Object data = beanData.getData(this.naturalKey[0]);
            return data == null ? null : data.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (String key : this.naturalKey) {
            Object val = beanData.getData(key);
            if (val == null) {
                return null;
            }
            sb.append(val).append(';');
        }
        return sb.toString();
    }

    CachedBeanData beanCacheGetData(String key) {
        return (CachedBeanData)this.getBeanCache().get((Object)key);
    }

    T beanCacheGet(String key, Boolean readOnly, PersistenceContext context) {
        T bean = this.beanCacheGetInternal(key, readOnly, context);
        if (bean != null) {
            this.setupContext(bean, context);
        }
        return bean;
    }

    private T beanCacheGetInternal(String key, Boolean readOnly, PersistenceContext context) {
        CachedBeanData data = (CachedBeanData)this.getBeanCache().get((Object)key);
        if (data == null) {
            if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
                beanLog.log(System.Logger.Level.TRACE, "   GET {0}({1}) - cache miss", this.cacheName, key);
            }
            return null;
        }
        if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
            beanLog.log(System.Logger.Level.TRACE, "   GET {0}({1}) - hit", this.cacheName, key);
        }
        return this.convertToBean(key, readOnly, context, data);
    }

    private T convertToBean(Object id, Boolean readOnly, PersistenceContext context, CachedBeanData data) {
        Object bean;
        if (this.cacheSharableBeans && !Boolean.FALSE.equals(readOnly) && (bean = data.getSharableBean()) != null) {
            if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
                beanLog.log(System.Logger.Level.TRACE, "   GET {0}({1}) - hit shared bean", this.cacheName, id);
            }
            return (T)bean;
        }
        return (T)this.loadBean(id, readOnly, data, context);
    }

    private EntityBean loadBean(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        return this.loadBeanDirect(id, readOnly, data, context);
    }

    EntityBean loadBeanDirect(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        id = this.desc.convertId(id);
        EntityBean bean = null;
        if (context == null) {
            context = new DefaultPersistenceContext();
        } else {
            bean = (EntityBean)this.desc.contextGet(context, id);
        }
        if (bean == null) {
            bean = this.desc.createEntityBean();
            this.desc.setId(id, bean);
            this.desc.contextPut(context, id, bean);
            EntityBeanIntercept ebi = bean._ebean_getIntercept();
            ebi.setBeanLoader((BeanLoader)this.desc.l2BeanLoader());
            if (Boolean.TRUE.equals(readOnly)) {
                ebi.setReadOnly(true);
            }
            ebi.setPersistenceContext(context);
        }
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        return bean;
    }

    EntityBean embeddedBeanLoad(CachedBeanData data, PersistenceContext context) {
        return this.embeddedBeanLoadDirect(data, context);
    }

    EntityBean embeddedBeanLoadDirect(CachedBeanData data, PersistenceContext context) {
        EntityBean bean = this.desc.createEntityBean();
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        return bean;
    }

    void beanCacheApplyInvalidate(Collection<String> keys) {
        if (this.beanCache != null) {
            if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
                beanLog.log(System.Logger.Level.DEBUG, "   MREMOVE {0}({1})", this.cacheName, keys);
            }
            this.beanCache.removeAll(new HashSet<String>(keys));
        }
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheClear();
        }
    }

    Set<EntityBeanIntercept> beanCacheLoadAll(Set<EntityBeanIntercept> batch, PersistenceContext context, int lazyLoadProperty, String propertyName) {
        HashMap<String, EntityBeanIntercept> ebis = new HashMap<String, EntityBeanIntercept>();
        for (EntityBeanIntercept ebi : batch) {
            ebis.put(this.desc.cacheKeyForBean(ebi.owner()), ebi);
        }
        Map hits = this.getBeanCache().getAll(ebis.keySet());
        if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
            beanLog.log(System.Logger.Level.TRACE, "   MLOAD {0}({1}) - got hits ({2})", this.cacheName, ebis.keySet(), hits.size());
        }
        HashSet<EntityBeanIntercept> loaded = new HashSet<EntityBeanIntercept>();
        for (Map.Entry hit : hits.entrySet()) {
            Object key = hit.getKey();
            EntityBeanIntercept ebi = (EntityBeanIntercept)ebis.remove(key);
            CachedBeanData cacheData = (CachedBeanData)hit.getValue();
            if (lazyLoadProperty > -1 && !cacheData.isLoaded(propertyName)) {
                if (!beanLog.isLoggable(System.Logger.Level.TRACE)) continue;
                beanLog.log(System.Logger.Level.TRACE, "   load {0}({1}) - cache miss on property({2})", this.cacheName, key, propertyName);
                continue;
            }
            CachedBeanDataToBean.load(this.desc, ebi.owner(), cacheData, context);
            loaded.add(ebi);
            if (!beanLog.isLoggable(System.Logger.Level.DEBUG)) continue;
            beanLog.log(System.Logger.Level.DEBUG, "   load {0}({1}) - hit", this.cacheName, key);
        }
        if (!ebis.isEmpty() && beanLog.isLoggable(System.Logger.Level.TRACE)) {
            beanLog.log(System.Logger.Level.TRACE, "   load {0}({1}) - cache miss", this.cacheName, ebis.keySet());
        }
        return loaded;
    }

    boolean beanCacheLoad(EntityBean bean, EntityBeanIntercept ebi, String key, PersistenceContext context) {
        CachedBeanData cacheData = (CachedBeanData)this.getBeanCache().get((Object)key);
        if (cacheData == null) {
            if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
                beanLog.log(System.Logger.Level.TRACE, "   LOAD {0}({1}) - cache miss", this.cacheName, key);
            }
            return false;
        }
        int lazyLoadProperty = ebi.lazyLoadPropertyIndex();
        if (lazyLoadProperty > -1 && !cacheData.isLoaded(ebi.lazyLoadProperty())) {
            if (beanLog.isLoggable(System.Logger.Level.TRACE)) {
                beanLog.log(System.Logger.Level.TRACE, "   LOAD {0}({1}) - cache miss on property({2})", this.cacheName, key, ebi.lazyLoadProperty());
            }
            return false;
        }
        CachedBeanDataToBean.load(this.desc, bean, cacheData, context);
        if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
            beanLog.log(System.Logger.Level.DEBUG, "   LOAD {0}({1}) - hit", this.cacheName, key);
        }
        return true;
    }

    void cacheUpdateQuery(boolean update, SpiTransaction transaction) {
        if (this.invalidateQueryCache || this.cacheNotifyOnAll || !update && this.cacheNotifyOnDelete) {
            transaction.event().add(this.desc.baseTable(), false, update, !update);
        }
    }

    void persistDeleteIds(Collection<Object> ids, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache != null) {
                changeSet.addBeanRemoveMany(this.desc, ids);
            }
            this.cacheDeleteImported(true, null, changeSet);
        }
    }

    void persistDelete(Object id, PersistRequestBean<T> deleteRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache != null) {
                changeSet.addBeanRemove(this.desc, id);
            }
            this.cacheDeleteImported(true, deleteRequest.entityBean(), changeSet);
        }
    }

    void persistInsert(PersistRequestBean<T> insertRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            this.cacheDeleteImported(false, insertRequest.entityBean(), changeSet);
            changeSet.addBeanInsert(this.desc.baseTable());
        }
    }

    private void cacheDeleteImported(boolean clear, EntityBean entityBean, CacheChangeSet changeSet) {
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheDelete(clear, entityBean, changeSet);
        }
    }

    void persistUpdate(Object id, PersistRequestBean<T> updateRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache == null) {
                return;
            }
            List<BeanPropertyAssocMany<?>> manyCollections = updateRequest.updatedManyForL2Cache();
            if (manyCollections != null) {
                for (BeanPropertyAssocMany<?> many : manyCollections) {
                    Object details;
                    CachedManyIds entry = this.createManyIds(many, details = many.getValue(updateRequest.entityBean()));
                    if (entry == null) continue;
                    String parentKey = this.desc.cacheKey(id);
                    changeSet.addManyPut(this.desc, many.name(), parentKey, entry);
                }
            }
            updateRequest.addBeanUpdate(changeSet);
        }
    }

    void persistTableIUD(TransactionEventTable.TableIUD tableIUD, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
            return;
        }
        if (this.noCaching) {
            return;
        }
        changeSet.addClearQuery(this.desc);
        if (tableIUD.isUpdateOrDelete()) {
            changeSet.addClearBean(this.desc);
        }
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheClear(changeSet);
        }
    }

    void cacheNaturalKeyPut(String key, String newKey) {
        if (newKey != null) {
            this.naturalKeyCache.put((Object)newKey, (Object)key);
        }
    }

    void cacheBeanUpdate(String key, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        ServerCache cache = this.getBeanCache();
        CachedBeanData existingData = (CachedBeanData)cache.get((Object)key);
        if (existingData != null) {
            String oldKey;
            long currentVersion = existingData.getVersion();
            if (version > 0L && version < currentVersion) {
                if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
                    beanLog.log(System.Logger.Level.DEBUG, "   REMOVE {0}({1}) - version conflict old:{2} new:{3}", this.cacheName, key, currentVersion, version);
                }
                cache.remove((Object)key);
            } else {
                if (version == 0L) {
                    version = currentVersion;
                }
                CachedBeanData newData = existingData.update(changes, version);
                if (beanLog.isLoggable(System.Logger.Level.DEBUG)) {
                    beanLog.log(System.Logger.Level.DEBUG, "   UPDATE {0}({1})  changes:{2}", this.cacheName, key, changes);
                }
                cache.put((Object)key, (Object)newData);
            }
            if (updateNaturalKey && (oldKey = this.calculateNaturalKey(existingData)) != null) {
                if (natLog.isLoggable(System.Logger.Level.DEBUG)) {
                    natLog.log(System.Logger.Level.DEBUG, ".. update {0} REMOVE({1}) - old key for ({2})", this.cacheName, oldKey, key);
                }
                this.naturalKeyCache.remove((Object)oldKey);
            }
        }
    }
}

