/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.id;

import io.ebean.bean.EntityBean;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.id.IdBinder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IdBinderEmbedded
implements IdBinder {
    private final BeanPropertyAssocOne<?> embIdProperty;
    private final boolean idInExpandedForm;
    private final boolean idClass;
    private BeanProperty[] props;
    private BeanDescriptor<?> idDesc;
    private String idInValueSql;

    public IdBinderEmbedded(boolean idInExpandedForm, BeanPropertyAssocOne<?> embIdProperty) {
        this.idInExpandedForm = idInExpandedForm;
        this.embIdProperty = embIdProperty;
        this.idClass = "_$IdClass$".equals(embIdProperty.name());
    }

    @Override
    public void initialise() {
        this.idDesc = this.embIdProperty.targetDescriptor();
        this.props = this.embIdProperty.properties();
        this.idInValueSql = this.idInExpandedForm ? this.idInExpanded() : this.idInCompressed();
    }

    @Override
    public String idNullOr(String prefix, String filterManyExpression) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("((");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append("${").append(prefix).append('.').append(this.embIdProperty.name()).append('}').append(this.props[i].name()).append(" is null");
        }
        sb.append(") or (").append(filterManyExpression).append("))");
        return sb.toString();
    }

    @Override
    public String idSelect() {
        return this.embIdProperty.name();
    }

    @Override
    public boolean isIdInExpandedForm() {
        return this.idInExpandedForm;
    }

    private String idInExpanded() {
        StringBuilder sb = new StringBuilder(30);
        sb.append('(');
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(this.idDesc.baseTableAlias()).append('.').append(this.props[i].dbColumn()).append("=?");
        }
        sb.append(')');
        return sb.toString();
    }

    private String idInCompressed() {
        StringBuilder sb = new StringBuilder(this.props.length * 2 + 2).append('(');
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public BeanProperty beanProperty() {
        return this.embIdProperty;
    }

    public BeanDescriptor<?> descriptor() {
        return this.idDesc;
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        if (!this.idClass) {
            prefix = SplitName.add((String)prefix, (String)this.embIdProperty.name());
        }
        for (BeanProperty prop : this.props) {
            prop.buildRawSqlSelectChain(prefix, selectChain);
        }
    }

    @Override
    public BeanProperty findBeanProperty(String dbColumnName) {
        for (BeanProperty prop : this.props) {
            if (!dbColumnName.equalsIgnoreCase(prop.dbColumn())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean isComplexId() {
        return true;
    }

    @Override
    public int size() {
        return this.props.length;
    }

    @Override
    public String orderBy() {
        return this.orderBy(null, true);
    }

    @Override
    public String orderBy(String pathPrefix, boolean ascending) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (pathPrefix != null) {
                sb.append(pathPrefix).append('.');
            }
            if (!this.idClass) {
                sb.append(this.embIdProperty.name()).append('.');
            }
            sb.append(this.props[i].name());
            if (ascending) continue;
            sb.append(" desc");
        }
        return sb.toString();
    }

    public BeanProperty[] properties() {
        return this.props;
    }

    @Override
    public String idInValueExprDelete(int size) {
        if (size <= 0) {
            throw new IndexOutOfBoundsException("The size must be at least 1");
        }
        if (!this.idInExpandedForm) {
            return this.idInValueExpr(false, size);
        }
        StringBuilder sb = new StringBuilder(80);
        sb.append('(');
        for (int j = 0; j < size; ++j) {
            if (j > 0) {
                sb.append(" or ");
            }
            sb.append('(');
            for (int i = 0; i < this.props.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(this.props[i].dbColumn()).append("=?");
            }
            sb.append(')');
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public String idInValueExpr(boolean not, int size) {
        if (size <= 0) {
            throw new IndexOutOfBoundsException("The size must be at least 1");
        }
        StringBuilder sb = new StringBuilder(80);
        if (not) {
            sb.append(" not");
        }
        if (!this.idInExpandedForm) {
            sb.append(" in");
        }
        sb.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                if (this.idInExpandedForm) {
                    sb.append(" or ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.idInValueSql);
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public Object[] values(EntityBean bean) {
        return this.bindValues(this.embIdProperty.getValue(bean));
    }

    @Override
    public Object[] bindValues(Object value) {
        EntityBean bean = (EntityBean)value;
        Object[] bindValues = new Object[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            bindValues[i] = this.props[i].getValue(bean);
        }
        return bindValues;
    }

    @Override
    public Object convertForJson(EntityBean bean) {
        EntityBean ebValue = (EntityBean)this.embIdProperty.getValue(bean);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (BeanProperty prop : this.props) {
            map.put(prop.name(), prop.getValue(ebValue));
        }
        return map;
    }

    @Override
    public Object convertFromJson(Object value) {
        Map map = (Map)value;
        EntityBean idValue = this.idDesc.createEntityBean();
        for (BeanProperty prop : this.props) {
            prop.setValue(idValue, map.get(prop.name()));
        }
        return idValue;
    }

    @Override
    public void bindId(DefaultSqlUpdate sqlUpdate, Object value) {
        EntityBean bean = (EntityBean)value;
        for (BeanProperty prop : this.props) {
            sqlUpdate.setParameter(prop.getValue(bean));
        }
    }

    @Override
    public void bindId(DataBind dataBind, Object value) throws SQLException {
        EntityBean bean = (EntityBean)value;
        for (BeanProperty prop : this.props) {
            prop.bind(dataBind, prop.getValue(bean));
        }
    }

    @Override
    public void addBindValues(DefaultSqlUpdate sqlUpdate, Collection<?> values) {
        for (Object value : values) {
            this.bindId(sqlUpdate, value);
        }
    }

    @Override
    public void addBindValues(SpiExpressionBind request, Collection<?> values) {
        for (Object value : values) {
            EntityBean bean = (EntityBean)value;
            for (BeanProperty prop : this.props) {
                request.addBindValue(prop.getValue(bean));
            }
        }
    }

    @Override
    public Object readData(DataInput dataInput) throws IOException {
        EntityBean embId = this.idDesc.createEntityBean();
        boolean notNull = true;
        for (BeanProperty prop : this.props) {
            Object value = prop.readData(dataInput);
            prop.setValue(embId, value);
            if (value != null) continue;
            notNull = false;
        }
        return notNull ? embId : null;
    }

    @Override
    public void writeData(DataOutput dataOutput, Object idValue) throws IOException {
        EntityBean bean = (EntityBean)idValue;
        for (BeanProperty prop : this.props) {
            prop.writeData(dataOutput, prop.getValue(bean));
        }
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        for (BeanProperty prop : this.props) {
            prop.loadIgnore(ctx);
        }
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        EntityBean embId = this.idDesc.createEntityBean();
        boolean nullValue = true;
        for (BeanProperty prop : this.props) {
            Object value = prop.read(ctx);
            if (value == null) continue;
            prop.setValue(embId, value);
            nullValue = false;
        }
        return nullValue ? null : embId;
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        Object embId = this.read(ctx);
        if (embId != null) {
            this.embIdProperty.setValue(bean, embId);
            return embId;
        }
        return null;
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        for (BeanProperty prop : this.props) {
            prop.appendSelect(ctx, subQuery);
        }
    }

    @Override
    public String assocInExpr(String prefix) {
        StringBuilder sb = new StringBuilder(80);
        sb.append('(');
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (prefix != null) {
                sb.append(prefix).append('.');
            }
            sb.append(this.props[i].name());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String assocExpr(String prefix, String operator) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (prefix != null) {
                sb.append(prefix).append('.');
            }
            if (!this.idClass) {
                sb.append(this.embIdProperty.name()).append('.');
            }
            sb.append(this.props[i].name()).append(operator);
        }
        return sb.toString();
    }

    @Override
    public String bindEqSql(String baseTableAlias) {
        StringBuilder sb = new StringBuilder(80);
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (baseTableAlias != null) {
                sb.append(baseTableAlias).append('.');
            }
            sb.append(this.props[i].dbColumn()).append("=?");
        }
        return sb.toString();
    }

    @Override
    public String bindInSql(String baseTableAlias) {
        if (this.idInExpandedForm) {
            return "";
        }
        StringBuilder sb = new StringBuilder(80);
        sb.append('(');
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (baseTableAlias != null) {
                sb.append(baseTableAlias).append('.');
            }
            sb.append(this.props[i].dbColumn());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Object convertId(Object idValue) {
        if (idValue instanceof String) {
            EntityBean embId = this.idDesc.createEntityBean();
            String[] rawValues = ((String)idValue).split("\\|");
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i].setValue(embId, this.props[i].parse(rawValues[i]));
            }
            return embId;
        }
        return idValue;
    }

    @Override
    public Object convertSetId(Object idValue, EntityBean bean) {
        if (bean != null) {
            this.embIdProperty.setValueIntercept(bean, idValue);
        }
        return idValue;
    }

    @Override
    public String cacheKey(Object value) {
        EntityBean bean = (EntityBean)value;
        StringBuilder sb = new StringBuilder(80);
        for (BeanProperty prop : this.props) {
            Object val = prop.getValue(bean);
            if (val != null) {
                sb.append(prop.format(val));
            }
            sb.append('|');
        }
        return sb.toString();
    }

    @Override
    public String cacheKeyFromBean(EntityBean bean) {
        return this.cacheKey(this.embIdProperty.getValue(bean));
    }
}

