/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebean.DatabaseBuilder;
import io.ebean.annotation.Cache;
import io.ebean.annotation.Identity;
import io.ebean.config.TableName;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.changelog.ChangeLogFilter;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.server.core.CacheOptions;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BindMaxLength;
import io.ebeaninternal.server.deploy.ChainedBeanPersistController;
import io.ebeaninternal.server.deploy.ChainedBeanPersistListener;
import io.ebeaninternal.server.deploy.ChainedBeanPostConstructListener;
import io.ebeaninternal.server.deploy.ChainedBeanPostLoad;
import io.ebeaninternal.server.deploy.ChainedBeanQueryAdapter;
import io.ebeaninternal.server.deploy.DeployPropertyParserMap;
import io.ebeaninternal.server.deploy.IdentityMode;
import io.ebeaninternal.server.deploy.IndexDefinition;
import io.ebeaninternal.server.deploy.PartitionMeta;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TablespaceMeta;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployBeanTable;
import io.ebeaninternal.server.deploy.meta.DeployIdentityMode;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.idgen.UuidV1IdGenerator;
import io.ebeaninternal.server.idgen.UuidV1RndIdGenerator;
import io.ebeaninternal.server.idgen.UuidV4IdGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

public class DeployBeanDescriptor<T> {
    private static final PropOrder PROP_ORDER = new PropOrder();
    private final DatabaseBuilder.Settings config;
    private final BeanDescriptorManager manager;
    private LinkedHashMap<String, DeployBeanProperty> propMap = new LinkedHashMap();
    private BeanDescriptor.EntityType entityType;
    private DeployBeanPropertyAssocOne<?> unidirectional;
    private DeployBeanProperty orderColumn;
    private Class<?> idClass;
    private DeployBeanPropertyAssocOne<?> idClassProperty;
    private DeployIdentityMode identityMode = DeployIdentityMode.auto();
    private PlatformIdGenerator idGenerator;
    private boolean idGeneratedValue;
    private String selectLastInsertedId;
    private ConcurrencyMode concurrencyMode;
    private List<IndexDefinition> indexDefinitions;
    private String storageEngine;
    private String baseTable;
    private String baseTableAsOf;
    private String baseTableVersionsBetween;
    private String[] dependentTables;
    private boolean historySupport;
    private TableName baseTableFull;
    private String[] properties;
    private final Class<T> beanType;
    private final List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private final List<BeanPersistListener> persistListeners = new ArrayList<BeanPersistListener>();
    private final List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private final List<BeanPostLoad> postLoaders = new ArrayList<BeanPostLoad>();
    private final List<BeanPostConstructListener> postConstructListeners = new ArrayList<BeanPostConstructListener>();
    private CacheOptions cacheOptions = CacheOptions.NO_CACHING;
    private BeanFindController beanFinder;
    private String name;
    private ChangeLogFilter changeLogFilter;
    private String dbComment;
    private PartitionMeta partitionMeta;
    private TablespaceMeta tablespaceMeta;
    private DeployBeanProperty idProperty;
    private TableJoin primaryKeyJoin;

    public DeployBeanDescriptor(BeanDescriptorManager manager, Class<T> beanType, DatabaseBuilder.Settings config) {
        this.manager = manager;
        this.config = config;
        this.beanType = beanType;
    }

    public BindMaxLength bindMaxLength() {
        return this.manager.bindMaxLength();
    }

    private String[] readPropertyNames() {
        try {
            Field field = this.beanType.getField("_ebean_props");
            return (String[])field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error getting _ebean_props field on type " + String.valueOf(this.beanType), e);
        }
    }

    public void setPropertyNames(String[] properties) {
        this.properties = properties;
    }

    public String[] propertyNames() {
        if (this.properties == null) {
            this.properties = this.readPropertyNames();
        }
        return this.properties;
    }

    public void setIdClass(Class<?> idClass) {
        this.idClass = idClass;
    }

    boolean isIdClass() {
        return this.idClass != null;
    }

    public void setPrimaryKeyJoin(TableJoin join) {
        this.primaryKeyJoin = join;
        this.identityMode.setIdType(IdType.EXTERNAL);
        this.idGenerator = null;
    }

    public TableJoin getPrimaryKeyJoin() {
        return this.primaryKeyJoin;
    }

    DeployBeanInfo<?> getDeploy(Class<?> cls) {
        return this.manager.deploy(cls);
    }

    public void setStorageEngine(String storageEngine) {
        this.storageEngine = storageEngine;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setHistorySupport() {
        this.historySupport = true;
    }

    public boolean isHistorySupport() {
        return this.historySupport;
    }

    public void setDbComment(String dbComment) {
        this.dbComment = dbComment;
    }

    public String getDbComment() {
        return this.dbComment;
    }

    public void setPartitionMeta(PartitionMeta partitionMeta) {
        this.partitionMeta = partitionMeta;
    }

    public PartitionMeta getPartitionMeta() {
        DeployBeanProperty beanProperty;
        if (this.partitionMeta != null && (beanProperty = this.getBeanProperty(this.partitionMeta.getProperty())) != null) {
            this.partitionMeta.setColumn(beanProperty.getDbColumn());
        }
        return this.partitionMeta;
    }

    public void setTablespaceMeta(TablespaceMeta tablespaceMeta) {
        this.tablespaceMeta = tablespaceMeta;
    }

    public TablespaceMeta getTablespaceMeta() {
        return this.tablespaceMeta;
    }

    public DeployBeanTable createDeployBeanTable() {
        DeployBeanTable beanTable = new DeployBeanTable(this.getBeanType());
        beanTable.setBaseTable(this.baseTable);
        beanTable.setIdProperty(this.idProperty());
        return beanTable;
    }

    public void setEntityType(BeanDescriptor.EntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isEmbedded() {
        return BeanDescriptor.EntityType.EMBEDDED == this.entityType;
    }

    public boolean isBaseTableType() {
        BeanDescriptor.EntityType et = this.getEntityType();
        return BeanDescriptor.EntityType.ORM == et;
    }

    public boolean isDocStoreOnly() {
        return BeanDescriptor.EntityType.DOC == this.entityType;
    }

    public BeanDescriptor.EntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = BeanDescriptor.EntityType.ORM;
        }
        return this.entityType;
    }

    public IdentityMode buildIdentityMode() {
        return new IdentityMode(this.identityMode);
    }

    public DeployIdentityMode getIdentityMode() {
        return this.identityMode;
    }

    public void setIdentityMode(Identity identity) {
        this.identityMode = new DeployIdentityMode(identity);
    }

    public void setIdentitySequence(int initialValue, int allocationSize, String seqName) {
        this.identityMode.setSequence(initialValue, allocationSize, seqName);
    }

    public void setIdentitySequenceGenerator(String genName) {
        this.identityMode.setSequenceGenerator(genName);
    }

    public int setIdentitySequenceBatchMode(boolean sequenceBatchMode) {
        return this.identityMode.setSequenceBatchMode(sequenceBatchMode);
    }

    public void setIdentityType(IdType type) {
        this.identityMode.setIdType(type);
    }

    public Class<T> getBeanType() {
        return this.beanType;
    }

    public void setChangeLogFilter(ChangeLogFilter changeLogFilter) {
        this.changeLogFilter = changeLogFilter;
    }

    public ChangeLogFilter getChangeLogFilter() {
        return this.changeLogFilter;
    }

    public void setInvalidateQueryCache(String region) {
        this.cacheOptions = CacheOptions.invalidateQueryCache(region);
    }

    public void setCache(Cache cache) {
        String[] properties;
        for (String property : properties = cache.naturalKey()) {
            DeployBeanProperty beanProperty = this.getBeanProperty(property);
            if (beanProperty == null) continue;
            beanProperty.setNaturalKey();
        }
        if (properties.length == 0) {
            properties = null;
        }
        this.cacheOptions = new CacheOptions(cache, properties);
    }

    public CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    DeployBeanPropertyAssocOne<?> getIdClassProperty() {
        return this.idClassProperty;
    }

    public DeployBeanPropertyAssocOne<?> getUnidirectional() {
        return this.unidirectional;
    }

    public void setUnidirectional(DeployBeanPropertyAssocOne<?> unidirectional) {
        this.unidirectional = unidirectional;
    }

    public void setOrderColumn(DeployBeanProperty orderColumn) {
        this.orderColumn = orderColumn;
    }

    DeployBeanProperty getOrderColumn() {
        return this.orderColumn;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this.concurrencyMode;
    }

    public void setConcurrencyMode(ConcurrencyMode concurrencyMode) {
        this.concurrencyMode = concurrencyMode;
    }

    public void addIndex(IndexDefinition c) {
        if (this.indexDefinitions == null) {
            this.indexDefinitions = new ArrayList<IndexDefinition>();
        }
        this.indexDefinitions.add(c);
    }

    public IndexDefinition[] getIndexDefinitions() {
        if (this.indexDefinitions == null) {
            return null;
        }
        return this.indexDefinitions.toArray(new IndexDefinition[0]);
    }

    public BeanFindController getBeanFinder() {
        return this.beanFinder;
    }

    public void setBeanFinder(BeanFindController beanFinder) {
        this.beanFinder = beanFinder;
    }

    public BeanPersistController getPersistController() {
        if (this.persistControllers.isEmpty()) {
            return null;
        }
        if (this.persistControllers.size() == 1) {
            return this.persistControllers.get(0);
        }
        return new ChainedBeanPersistController(this.persistControllers);
    }

    public BeanPersistListener getPersistListener() {
        if (this.persistListeners.isEmpty()) {
            return null;
        }
        if (this.persistListeners.size() == 1) {
            return this.persistListeners.get(0);
        }
        return new ChainedBeanPersistListener(this.persistListeners);
    }

    public BeanQueryAdapter getQueryAdapter() {
        if (this.queryAdapters.isEmpty()) {
            return null;
        }
        if (this.queryAdapters.size() == 1) {
            return this.queryAdapters.get(0);
        }
        return new ChainedBeanQueryAdapter(this.queryAdapters);
    }

    public BeanPostLoad getPostLoad() {
        if (this.postLoaders.isEmpty()) {
            return null;
        }
        if (this.postLoaders.size() == 1) {
            return this.postLoaders.get(0);
        }
        return new ChainedBeanPostLoad(this.postLoaders);
    }

    public BeanPostConstructListener getPostConstructListener() {
        if (this.postConstructListeners.isEmpty()) {
            return null;
        }
        if (this.postConstructListeners.size() == 1) {
            return this.postConstructListeners.get(0);
        }
        return new ChainedBeanPostConstructListener(this.postConstructListeners);
    }

    public void addPersistController(BeanPersistController controller) {
        this.persistControllers.add(controller);
    }

    public void addPersistListener(BeanPersistListener listener) {
        this.persistListeners.add(listener);
    }

    public void addQueryAdapter(BeanQueryAdapter queryAdapter) {
        this.queryAdapters.add(queryAdapter);
    }

    public void addPostLoad(BeanPostLoad postLoad) {
        this.postLoaders.add(postLoad);
    }

    public void addPostConstructListener(BeanPostConstructListener postConstructListener) {
        this.postConstructListeners.add(postConstructListener);
    }

    public String[] getDependentTables() {
        return this.dependentTables;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getBaseTableAsOf() {
        return this.historySupport ? this.baseTableAsOf : this.baseTable;
    }

    public String getBaseTableVersionsBetween() {
        return this.baseTableVersionsBetween;
    }

    public TableName getBaseTableFull() {
        return this.baseTableFull;
    }

    public void setView(String viewName, String[] dependentTables) {
        this.entityType = BeanDescriptor.EntityType.VIEW;
        this.dependentTables = dependentTables;
        this.setBaseTable(new TableName(viewName), "", "");
    }

    public void setBaseTable(TableName baseTableFull, String asOfSuffix, String versionsBetweenSuffix) {
        this.baseTableFull = baseTableFull;
        this.baseTable = baseTableFull == null ? null : baseTableFull.getQualifiedName();
        this.baseTableAsOf = this.baseTable + asOfSuffix;
        this.baseTableVersionsBetween = this.baseTable + versionsBetweenSuffix;
    }

    public void sortProperties() {
        ArrayList<DeployBeanProperty> list = new ArrayList<DeployBeanProperty>(this.propMap.values());
        list.sort(PROP_ORDER);
        this.propMap = new LinkedHashMap(list.size());
        for (DeployBeanProperty property : list) {
            this.addBeanProperty(property);
        }
    }

    public void postAnnotations() {
        if (this.idClass != null) {
            this.idClassProperty = new DeployBeanPropertyAssocOne(this, this.idClass);
            this.idClassProperty.setName("_$IdClass$");
            this.idClassProperty.setEmbedded();
            this.idClassProperty.setNullable(false);
        }
    }

    public DeployBeanProperty addBeanProperty(DeployBeanProperty prop) {
        return this.propMap.put(prop.getName(), prop);
    }

    public Collection<DeployBeanProperty> properties() {
        return this.propMap.values();
    }

    public DeployBeanProperty getBeanProperty(String propName) {
        return this.propMap.get(propName);
    }

    public String getFullName() {
        return this.beanType.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSelectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public void setSelectLastInsertedId(String selectLastInsertedId) {
        this.selectLastInsertedId = selectLastInsertedId;
    }

    public PlatformIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(PlatformIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean isIdGeneratedValue() {
        return this.idGeneratedValue;
    }

    public void setIdGeneratedValue() {
        this.idGeneratedValue = true;
    }

    public void setUuidGenerator() {
        if (this.idGenerator == null) {
            this.identityMode.setIdType(IdType.EXTERNAL);
            switch (this.config.getUuidVersion()) {
                case VERSION1: {
                    this.idGenerator = UuidV1IdGenerator.getInstance(this.config.getUuidStateFile(), this.config.getUuidNodeId());
                    break;
                }
                case VERSION1RND: {
                    this.idGenerator = UuidV1RndIdGenerator.INSTANCE;
                    break;
                }
                default: {
                    this.idGenerator = UuidV4IdGenerator.INSTANCE;
                }
            }
        }
    }

    public void setCustomIdGenerator(PlatformIdGenerator idGenerator) {
        this.identityMode.setIdType(IdType.EXTERNAL);
        this.idGenerator = idGenerator;
    }

    public String toString() {
        return this.getFullName();
    }

    public Collection<DeployBeanProperty> propertiesAll() {
        return this.propMap.values();
    }

    public String getDefaultSelectClause() {
        StringBuilder sb = new StringBuilder();
        boolean hasLazyFetch = false;
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (prop.isTransient() || prop instanceof DeployBeanPropertyAssocMany) continue;
            if (prop.isFetchEager()) {
                sb.append(prop.getName()).append(',');
                continue;
            }
            hasLazyFetch = true;
        }
        if (!hasLazyFetch) {
            return null;
        }
        String selectClause = sb.toString();
        if (selectClause.isEmpty()) {
            throw new IllegalStateException("Bean " + this.getFullName() + " has no properties?");
        }
        return selectClause.substring(0, selectClause.length() - 1);
    }

    public boolean isPrimaryKeyCompoundOrNonNumeric() {
        DeployBeanProperty id = this.idProperty();
        if (id == null) {
            return false;
        }
        if (id instanceof DeployBeanPropertyAssocOne) {
            return ((DeployBeanPropertyAssocOne)id).isCompound();
        }
        return !id.isDbNumberType();
    }

    public String getSinglePrimaryKeyColumn() {
        DeployBeanProperty id = this.idProperty();
        if (id != null) {
            if (id instanceof DeployBeanPropertyAssoc) {
                return null;
            }
            return id.getDbColumn();
        }
        return null;
    }

    public DeployBeanProperty idProperty() {
        if (this.idProperty != null) {
            return this.idProperty;
        }
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!prop.isId()) continue;
            this.idProperty = prop;
            return this.idProperty;
        }
        return null;
    }

    public DeployBeanPropertyAssocOne<?> findJoinToTable(String tableName) {
        List<DeployBeanPropertyAssocOne<?>> assocOne = this.propertiesAssocOne();
        for (DeployBeanPropertyAssocOne<?> prop : assocOne) {
            DeployTableJoin tableJoin = prop.getTableJoin();
            if (tableJoin == null || !tableJoin.getTable().equalsIgnoreCase(tableName)) continue;
            return prop;
        }
        return null;
    }

    public List<DeployBeanPropertyAssocOne<?>> propertiesAssocOne() {
        ArrayList list = new ArrayList();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!(prop instanceof DeployBeanPropertyAssocOne) || prop.isEmbedded()) continue;
            list.add((DeployBeanPropertyAssocOne)prop);
        }
        return list;
    }

    public List<DeployBeanPropertyAssocMany<?>> propertiesAssocMany() {
        ArrayList list = new ArrayList();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!(prop instanceof DeployBeanPropertyAssocMany)) continue;
            list.add((DeployBeanPropertyAssocMany)prop);
        }
        return list;
    }

    public List<DeployBeanProperty> propertiesBase() {
        ArrayList<DeployBeanProperty> list = new ArrayList<DeployBeanProperty>();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (prop instanceof DeployBeanPropertyAssoc || prop.isId()) continue;
            list.add(prop);
        }
        return list;
    }

    public String parse(String aggregation) {
        return new Parser(this).parse(aggregation);
    }

    private String getDeployWord(String expression) {
        DeployBeanPropertyAssoc prop;
        DeployBeanProperty beanProperty;
        if (expression.charAt(expression.length() - 1) == '(') {
            return null;
        }
        String[] split = SplitName.split((String)expression);
        if (split[0] == null) {
            DeployBeanProperty property = this.propMap.get(expression);
            return property == null ? null : "${ta}." + property.getDbColumn();
        }
        DeployBeanProperty property = this.propMap.get(split[0]);
        if (property instanceof DeployBeanPropertyAssoc && (beanProperty = (prop = (DeployBeanPropertyAssoc)property).getTargetDeploy().getBeanProperty(split[1])) != null) {
            return "u1." + beanProperty.getDbColumn();
        }
        return null;
    }

    private static class PropOrder
    implements Comparator<DeployBeanProperty> {
        private PropOrder() {
        }

        @Override
        public int compare(DeployBeanProperty o1, DeployBeanProperty o2) {
            return Integer.compare(o2.getSortOrder(), o1.getSortOrder());
        }
    }

    private static class Parser
    extends DeployPropertyParserMap {
        private final DeployBeanDescriptor<?> descriptor;

        Parser(DeployBeanDescriptor<?> descriptor) {
            super(null);
            this.descriptor = descriptor;
        }

        @Override
        public String deployWord(String expression) {
            return this.descriptor.getDeployWord(expression);
        }
    }
}

