/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.SubQueryOp;
import io.ebeaninternal.server.expression.UnsupportedDocStoreExpression;
import io.ebeaninternal.server.query.CQuery;
import java.util.List;

final class SubQueryExpression
extends AbstractExpression
implements UnsupportedDocStoreExpression {
    private final SubQueryOp op;
    private final SpiQuery<?> subQuery;
    private List<Object> bindParams;
    private String sql;

    SubQueryExpression(SubQueryOp op, String propertyName, SpiQuery<?> subQuery) {
        super(propertyName);
        this.op = op;
        this.subQuery = subQuery;
    }

    SubQueryExpression(SubQueryOp op, String propertyName, String sql, List<Object> bindParams) {
        super(propertyName);
        this.op = op;
        this.subQuery = null;
        this.sql = sql;
        this.bindParams = bindParams;
    }

    @Override
    public SpiExpression copy() {
        return this.subQuery == null ? this : new SubQueryExpression(this.op, this.propName, (SpiQuery<?>)this.subQuery.copy());
    }

    @Override
    public void simplify() {
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        CQuery<?> subQuery = this.compileSubQuery(request);
        this.bindParams = subQuery.predicates().whereExprBindValues();
        this.sql = subQuery.generatedSql().replace('\n', ' ');
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("SubQuery[").append(this.propName).append(this.op.expression).append(" sql:").append(this.sql).append(" ?:").append(this.bindParams.size()).append(']');
    }

    private CQuery<?> compileSubQuery(BeanQueryRequest<?> queryRequest) {
        SpiEbeanServer ebeanServer = (SpiEbeanServer)queryRequest.database();
        return ebeanServer.compileQuery(SpiQuery.Type.SQ_EX, this.subQuery, queryRequest.transaction());
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        this.subQuery.queryBindKey(key);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.property(this.propName).append(this.op.expression).append('(').append(this.sql).append(')');
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        for (Object bindParam : this.bindParams) {
            request.addBindValue(bindParam);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        SubQueryExpression that = (SubQueryExpression)other;
        if (this.bindParams.size() != that.bindParams.size()) {
            return false;
        }
        for (int i = 0; i < this.bindParams.size(); ++i) {
            if (this.bindParams.get(i).equals(that.bindParams.get(i))) continue;
            return false;
        }
        return true;
    }
}

