/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;

final class ScalarTypeMathBigInteger
extends ScalarTypeBase<BigInteger> {
    ScalarTypeMathBigInteger() {
        super(BigInteger.class, false, -5);
    }

    public void bind(DataBinder binder, BigInteger value) throws SQLException {
        if (value == null) {
            binder.setNull(-5);
        } else {
            binder.setLong(value.longValue());
        }
    }

    public BigInteger read(DataReader reader) throws SQLException {
        Long value = reader.getLong();
        if (value == null) {
            return null;
        }
        return new BigInteger(String.valueOf(value));
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toLong((Object)value);
    }

    public BigInteger toBeanType(Object value) {
        return BasicTypeConverter.toBigInteger((Object)value);
    }

    public String formatValue(BigInteger v) {
        return v.toString();
    }

    public BigInteger parse(String value) {
        return new BigInteger(value);
    }

    public BigInteger readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return BigInteger.valueOf(dataInput.readLong());
    }

    public void writeData(DataOutput dataOutput, BigInteger value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(value.longValue());
        }
    }

    public BigInteger jsonRead(JsonParser parser) throws IOException {
        return parser.getDecimalValue().toBigInteger();
    }

    public void jsonWrite(JsonGenerator writer, BigInteger value) throws IOException {
        writer.writeNumber(value.longValue());
    }

    public DocPropertyType docType() {
        return DocPropertyType.LONG;
    }
}

