/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebean.annotation.Identity;
import io.ebean.annotation.IdentityGenerated;
import io.ebean.annotation.IdentityType;
import io.ebean.config.dbplatform.IdType;

public final class DeployIdentityMode {
    private IdType type;
    private final IdentityGenerated generated;
    private int start;
    private int increment;
    private final int cache;
    private String sequenceName;
    private boolean platformDefault;

    public static DeployIdentityMode auto() {
        return new DeployIdentityMode(IdType.AUTO);
    }

    public DeployIdentityMode(Identity id) {
        this.type = DeployIdentityMode.idType(id.type());
        this.generated = id.generated();
        this.start = id.start();
        this.increment = id.increment();
        this.cache = id.cache();
        this.sequenceName = id.sequenceName();
    }

    private DeployIdentityMode(IdType type) {
        this.type = type;
        this.generated = IdentityGenerated.AUTO;
        this.sequenceName = "";
        this.start = 0;
        this.increment = 0;
        this.cache = 0;
    }

    public void setPlatformType(IdType type) {
        this.type = type;
        this.platformDefault = true;
    }

    public void setSequence(int initialValue, int allocationSize, String sequenceName) {
        this.start = initialValue;
        this.increment = allocationSize;
        this.sequenceName = sequenceName;
    }

    public void setSequenceGenerator(String genName) {
        if (this.sequenceName == null || this.sequenceName.isEmpty()) {
            this.sequenceName = genName;
        }
    }

    public int setSequenceBatchMode(boolean sequenceBatchMode) {
        if (sequenceBatchMode) {
            this.increment = 1;
        } else if (this.increment == 0) {
            this.increment = 50;
        }
        return this.increment;
    }

    public void setIdType(IdType type) {
        this.type = type;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public boolean isPlatformDefault() {
        return this.platformDefault;
    }

    public IdType getIdType() {
        return this.type;
    }

    public IdentityGenerated getGenerated() {
        return this.generated;
    }

    public int getStart() {
        return this.start;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getCache() {
        return this.cache;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public boolean isSequence() {
        return this.type == IdType.SEQUENCE;
    }

    public boolean isIdentity() {
        return this.type == IdType.IDENTITY;
    }

    public boolean isExternal() {
        return this.type == IdType.EXTERNAL;
    }

    public boolean isAuto() {
        return this.type == IdType.AUTO;
    }

    private static IdType idType(IdentityType type) {
        switch (type) {
            case AUTO: {
                return IdType.AUTO;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case IDENTITY: {
                return IdType.IDENTITY;
            }
            case APPLICATION: {
                return IdType.EXTERNAL;
            }
        }
        throw new IllegalStateException("type " + String.valueOf(type) + " not expected?");
    }
}

