/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.CacheMode;
import io.ebean.CountDistinctOrder;
import io.ebean.DtoQuery;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.InTuples;
import io.ebean.Junction;
import io.ebean.OrderBy;
import io.ebean.PagedList;
import io.ebean.Pairs;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.api.SpiJunction;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DefaultExpressionList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class JunctionExpression<T>
implements SpiJunction<T>,
SpiExpression,
ExpressionList<T> {
    DefaultExpressionList<T> exprList;
    Junction.Type type;

    JunctionExpression(Junction.Type type, Query<T> query, ExpressionList<T> parent) {
        this.type = type;
        this.exprList = new DefaultExpressionList<T>(query, parent);
    }

    JunctionExpression(Junction.Type type, DefaultExpressionList<T> exprList) {
        this.type = type;
        this.exprList = exprList;
    }

    @Override
    public void prefixProperty(String path) {
        this.exprList.prefixProperty(path);
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
        this.exprList.simplifyEntries();
        List<SpiExpression> list = this.exprList.list;
        if (list.size() == 1 && list.get(0) instanceof JunctionExpression) {
            JunctionExpression nested = (JunctionExpression)list.get(0);
            if (this.type == Junction.Type.AND && !nested.type.isText()) {
                this.exprList = nested.exprList;
                this.type = nested.type;
            } else if (this.type == Junction.Type.NOT && nested.type == Junction.Type.AND) {
                this.exprList = nested.exprList;
            }
        }
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return new JunctionExpression<T>(this.type, this.exprList.copyForPlanKey());
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        List<SpiExpression> list = this.exprList.internalList();
        boolean parentOuterJoins = manyWhereJoin.isRequireOuterJoins();
        if (this.type == Junction.Type.OR) {
            manyWhereJoin.setRequireOuterJoins(true);
        }
        for (SpiExpression expr : list) {
            expr.containsMany(desc, manyWhereJoin);
        }
        if (this.type == Junction.Type.OR && !parentOuterJoins) {
            manyWhereJoin.setRequireOuterJoins(false);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        this.exprList.validate(validation);
    }

    public Junction<T> add(Expression item) {
        this.exprList.add(item);
        return this;
    }

    public Junction<T> addAll(ExpressionList<T> addList) {
        this.exprList.addAll(addList);
        return this;
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        for (SpiExpression expr : this.exprList.internalList()) {
            expr.addBindValues(request);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        List<SpiExpression> list = this.exprList.internalList();
        if (!list.isEmpty()) {
            request.append(this.type.prefix());
            request.append('(');
            for (int i = 0; i < list.size(); ++i) {
                SpiExpression item = list.get(i);
                if (i > 0) {
                    request.append(this.type.literal());
                }
                item.addSql(request);
            }
            request.append(')');
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        for (SpiExpression expr : this.exprList.internalList()) {
            expr.prepareExpression(request);
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append(this.type).append('[');
        for (SpiExpression expr : this.exprList.internalList()) {
            expr.queryPlanHash(builder);
            builder.append(',');
        }
        builder.append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        for (SpiExpression expr : this.exprList.internalList()) {
            expr.queryBindKey(key);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        JunctionExpression that = (JunctionExpression)other;
        return this.type == that.type && this.exprList.isSameByBind(that.exprList);
    }

    public ExpressionList<T> allEq(Map<String, Object> propertyMap) {
        return this.exprList.allEq(propertyMap);
    }

    public ExpressionList<T> and(Expression expOne, Expression expTwo) {
        return this.exprList.and(expOne, expTwo);
    }

    public ExpressionList<T> inRangeWith(String lowProperty, String highProperty, Object value) {
        return this.exprList.inRangeWith(lowProperty, highProperty, value);
    }

    public ExpressionList<T> inRangeWithProperties(String propertyName, String lowProperty, String highProperty) {
        return this.exprList.inRangeWithProperties(propertyName, lowProperty, highProperty);
    }

    public ExpressionList<T> inRange(String propertyName, Object value1, Object value2) {
        return this.exprList.inRange(propertyName, value1, value2);
    }

    public ExpressionList<T> between(String propertyName, Object value1, Object value2) {
        return this.exprList.between(propertyName, value1, value2);
    }

    public ExpressionList<T> betweenProperties(String lowProperty, String highProperty, Object value) {
        return this.exprList.betweenProperties(lowProperty, highProperty, value);
    }

    public ExpressionList<T> contains(String propertyName, String value) {
        return this.exprList.contains(propertyName, value);
    }

    public ExpressionList<T> endsWith(String propertyName, String value) {
        return this.exprList.endsWith(propertyName, value);
    }

    public ExpressionList<T> eq(String propertyName, Query<?> subQuery) {
        return this.exprList.eq(propertyName, subQuery);
    }

    public ExpressionList<T> eq(String propertyName, Object value) {
        return this.exprList.eq(propertyName, value);
    }

    public ExpressionList<T> eqIfPresent(String propertyName, @Nullable Object value) {
        return value == null ? this : this.exprList.eq(propertyName, value);
    }

    public ExpressionList<T> eqOrNull(String propertyName, Object value) {
        return this.exprList.eqOrNull(propertyName, value);
    }

    public ExpressionList<T> exampleLike(Object example) {
        return this.exprList.exampleLike(example);
    }

    public ExpressionList<T> filterMany(String prop) {
        throw new IllegalStateException("filterMany not allowed on Junction expression list");
    }

    public ExpressionList<T> filterManyRaw(String manyProperty, String rawExpression, Object ... params) {
        throw new IllegalStateException("filterMany not allowed on Junction expression list");
    }

    public Query<T> usingTransaction(Transaction transaction) {
        return this.exprList.usingTransaction(transaction);
    }

    public Query<T> usingConnection(Connection connection) {
        return this.exprList.usingConnection(connection);
    }

    public int delete() {
        return this.exprList.delete();
    }

    public int delete(Transaction transaction) {
        return this.exprList.delete(transaction);
    }

    public int update() {
        return this.exprList.update();
    }

    public int update(Transaction transaction) {
        return this.exprList.update(transaction);
    }

    public Query<T> asOf(Timestamp asOf) {
        return this.exprList.asOf(asOf);
    }

    public <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.exprList.asDto(dtoClass);
    }

    public UpdateQuery<T> asUpdate() {
        return this.exprList.asUpdate();
    }

    public Query<T> setIncludeSoftDeletes() {
        return this.exprList.setIncludeSoftDeletes();
    }

    public List<Version<T>> findVersions() {
        return this.exprList.findVersions();
    }

    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.exprList.findVersionsBetween(start, end);
    }

    public Query<T> apply(FetchPath fetchPath) {
        return this.exprList.apply(fetchPath);
    }

    public boolean exists() {
        return this.exprList.exists();
    }

    public FutureIds<T> findFutureIds() {
        return this.exprList.findFutureIds();
    }

    public FutureList<T> findFutureList() {
        return this.exprList.findFutureList();
    }

    public FutureRowCount<T> findFutureCount() {
        return this.exprList.findFutureCount();
    }

    public <A> List<A> findIds() {
        return this.exprList.findIds();
    }

    public QueryIterator<T> findIterate() {
        return this.exprList.findIterate();
    }

    public void findEach(Consumer<T> consumer) {
        this.exprList.findEach(consumer);
    }

    public void findEach(int batch, Consumer<List<T>> consumer) {
        this.exprList.findEach(batch, consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.exprList.findEachWhile(consumer);
    }

    public List<T> findList() {
        return this.exprList.findList();
    }

    public <K> Map<K, T> findMap() {
        return this.exprList.findMap();
    }

    public <A> List<A> findSingleAttributeList() {
        return this.exprList.findSingleAttributeList();
    }

    public <A> Set<A> findSingleAttributeSet() {
        return this.exprList.findSingleAttributeSet();
    }

    public PagedList<T> findPagedList() {
        return this.exprList.findPagedList();
    }

    public int findCount() {
        return this.exprList.findCount();
    }

    public Set<T> findSet() {
        return this.exprList.findSet();
    }

    public @Nullable T findOne() {
        return this.exprList.findOne();
    }

    public Optional<T> findOneOrEmpty() {
        return this.exprList.findOneOrEmpty();
    }

    public Query<T> withLock(Query.LockType lockType) {
        return this.exprList.withLock(lockType);
    }

    public Query<T> withLock(Query.LockType lockType, Query.LockWait lockWait) {
        return this.exprList.withLock(lockType, lockWait);
    }

    public Query<T> forUpdate() {
        return this.exprList.forUpdate();
    }

    public Query<T> forUpdateNoWait() {
        return this.exprList.forUpdateNoWait();
    }

    public Query<T> forUpdateSkipLocked() {
        return this.exprList.forUpdateSkipLocked();
    }

    public ExpressionList<T> jsonExists(String propertyName, String path) {
        return this.exprList.jsonExists(propertyName, path);
    }

    public ExpressionList<T> jsonNotExists(String propertyName, String path) {
        return this.exprList.jsonNotExists(propertyName, path);
    }

    public ExpressionList<T> jsonEqualTo(String propertyName, String path, Object value) {
        return this.exprList.jsonEqualTo(propertyName, path, value);
    }

    public ExpressionList<T> jsonNotEqualTo(String propertyName, String path, Object val) {
        return this.exprList.jsonNotEqualTo(propertyName, path, val);
    }

    public ExpressionList<T> jsonGreaterThan(String propertyName, String path, Object val) {
        return this.exprList.jsonGreaterThan(propertyName, path, val);
    }

    public ExpressionList<T> jsonGreaterOrEqual(String propertyName, String path, Object val) {
        return this.exprList.jsonGreaterOrEqual(propertyName, path, val);
    }

    public ExpressionList<T> jsonLessThan(String propertyName, String path, Object val) {
        return this.exprList.jsonLessThan(propertyName, path, val);
    }

    public ExpressionList<T> jsonLessOrEqualTo(String propertyName, String path, Object val) {
        return this.exprList.jsonLessOrEqualTo(propertyName, path, val);
    }

    public ExpressionList<T> jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        return this.exprList.jsonBetween(propertyName, path, lowerValue, upperValue);
    }

    public ExpressionList<T> arrayContains(String propertyName, Object ... values) {
        return this.exprList.arrayContains(propertyName, values);
    }

    public ExpressionList<T> arrayNotContains(String propertyName, Object ... values) {
        return this.exprList.arrayNotContains(propertyName, values);
    }

    public ExpressionList<T> arrayIsEmpty(String propertyName) {
        return this.exprList.arrayIsEmpty(propertyName);
    }

    public ExpressionList<T> arrayIsNotEmpty(String propertyName) {
        return this.exprList.arrayIsNotEmpty(propertyName);
    }

    public ExpressionList<T> bitwiseAny(String propertyName, long flags) {
        return this.exprList.bitwiseAny(propertyName, flags);
    }

    public ExpressionList<T> bitwiseAll(String propertyName, long flags) {
        return this.exprList.bitwiseAll(propertyName, flags);
    }

    public ExpressionList<T> bitwiseAnd(String propertyName, long flags, long match) {
        return this.exprList.bitwiseAnd(propertyName, flags, match);
    }

    public ExpressionList<T> bitwiseNot(String propertyName, long flags) {
        return this.exprList.bitwiseNot(propertyName, flags);
    }

    public ExpressionList<T> ge(String propertyName, Query<?> subQuery) {
        return this.exprList.ge(propertyName, subQuery);
    }

    public ExpressionList<T> ge(String propertyName, Object value) {
        return this.exprList.ge(propertyName, value);
    }

    public ExpressionList<T> gt(String propertyName, Query<?> subQuery) {
        return this.exprList.gt(propertyName, subQuery);
    }

    public ExpressionList<T> gt(String propertyName, Object value) {
        return this.exprList.gt(propertyName, value);
    }

    public ExpressionList<T> gtOrNull(String propertyName, Object value) {
        return this.exprList.gtOrNull(propertyName, value);
    }

    public ExpressionList<T> geOrNull(String propertyName, Object value) {
        return this.exprList.geOrNull(propertyName, value);
    }

    public ExpressionList<T> gtIfPresent(String propertyName, @Nullable Object value) {
        return value == null ? this : this.exprList.gt(propertyName, value);
    }

    public ExpressionList<T> geIfPresent(String propertyName, @Nullable Object value) {
        return value == null ? this : this.exprList.ge(propertyName, value);
    }

    public ExpressionList<T> having() {
        throw new IllegalStateException("having() not allowed on Junction expression list");
    }

    public ExpressionList<T> icontains(String propertyName, String value) {
        return this.exprList.icontains(propertyName, value);
    }

    public ExpressionList<T> idEq(Object value) {
        return this.exprList.idEq(value);
    }

    public ExpressionList<T> idIn(Object ... idValues) {
        return this.exprList.idIn(idValues);
    }

    public ExpressionList<T> idIn(Collection<?> idValues) {
        return this.exprList.idIn(idValues);
    }

    public ExpressionList<T> iendsWith(String propertyName, String value) {
        return this.exprList.iendsWith(propertyName, value);
    }

    public ExpressionList<T> ieq(String propertyName, String value) {
        return this.exprList.ieq(propertyName, value);
    }

    public ExpressionList<T> ine(String propertyName, String value) {
        return this.exprList.ine(propertyName, value);
    }

    public ExpressionList<T> iexampleLike(Object example) {
        return this.exprList.iexampleLike(example);
    }

    public ExpressionList<T> ilike(String propertyName, String value) {
        return this.exprList.ilike(propertyName, value);
    }

    public ExpressionList<T> inPairs(Pairs pairs) {
        return this.exprList.inPairs(pairs);
    }

    public ExpressionList<T> inTuples(InTuples pairs) {
        return this.exprList.inTuples(pairs);
    }

    public ExpressionList<T> in(String propertyName, Collection<?> values) {
        return this.exprList.in(propertyName, values);
    }

    public ExpressionList<T> inOrEmpty(String propertyName, Collection<?> values) {
        return this.exprList.inOrEmpty(propertyName, values);
    }

    public ExpressionList<T> in(String propertyName, Object ... values) {
        return this.exprList.in(propertyName, values);
    }

    public ExpressionList<T> in(String propertyName, Query<?> subQuery) {
        return this.exprList.in(propertyName, subQuery);
    }

    public ExpressionList<T> exists(String sqlSubQuery, Object ... bindValues) {
        return this.exprList.exists(sqlSubQuery, bindValues);
    }

    public ExpressionList<T> notExists(String sqlSubQuery, Object ... bindValues) {
        return this.exprList.notExists(sqlSubQuery, bindValues);
    }

    public ExpressionList<T> inSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.inSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> notInSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.notInSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> eqSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.eqSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> neSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.neSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> gtSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.gtSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> geSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.geSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> ltSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.ltSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> leSubQuery(String propertyName, String sqlSubQuery, Object ... bindValues) {
        return this.exprList.leSubQuery(propertyName, sqlSubQuery, bindValues);
    }

    public ExpressionList<T> notIn(String propertyName, Collection<?> values) {
        return this.exprList.notIn(propertyName, values);
    }

    public ExpressionList<T> notIn(String propertyName, Object ... values) {
        return this.exprList.notIn(propertyName, values);
    }

    public ExpressionList<T> notIn(String propertyName, Query<?> subQuery) {
        return this.exprList.notIn(propertyName, subQuery);
    }

    public ExpressionList<T> isEmpty(String propertyName) {
        return this.exprList.isEmpty(propertyName);
    }

    public ExpressionList<T> isNotEmpty(String propertyName) {
        return this.exprList.isNotEmpty(propertyName);
    }

    public ExpressionList<T> exists(Query<?> subQuery) {
        return this.exprList.exists(subQuery);
    }

    public ExpressionList<T> notExists(Query<?> subQuery) {
        return this.exprList.notExists(subQuery);
    }

    public ExpressionList<T> isNotNull(String propertyName) {
        return this.exprList.isNotNull(propertyName);
    }

    public ExpressionList<T> isNull(String propertyName) {
        return this.exprList.isNull(propertyName);
    }

    public ExpressionList<T> istartsWith(String propertyName, String value) {
        return this.exprList.istartsWith(propertyName, value);
    }

    public ExpressionList<T> le(String propertyName, Query<?> subQuery) {
        return this.exprList.le(propertyName, subQuery);
    }

    public ExpressionList<T> le(String propertyName, Object value) {
        return this.exprList.le(propertyName, value);
    }

    public ExpressionList<T> like(String propertyName, String value) {
        return this.exprList.like(propertyName, value);
    }

    public ExpressionList<T> lt(String propertyName, Query<?> subQuery) {
        return this.exprList.lt(propertyName, subQuery);
    }

    public ExpressionList<T> lt(String propertyName, Object value) {
        return this.exprList.lt(propertyName, value);
    }

    public ExpressionList<T> ltOrNull(String propertyName, Object value) {
        return this.exprList.ltOrNull(propertyName, value);
    }

    public ExpressionList<T> leOrNull(String propertyName, Object value) {
        return this.exprList.leOrNull(propertyName, value);
    }

    public ExpressionList<T> ltIfPresent(String propertyName, @Nullable Object value) {
        return value == null ? this : this.exprList.lt(propertyName, value);
    }

    public ExpressionList<T> leIfPresent(String propertyName, @Nullable Object value) {
        return value == null ? this : this.exprList.le(propertyName, value);
    }

    public ExpressionList<T> ne(String propertyName, Query<?> subQuery) {
        return this.exprList.ne(propertyName, subQuery);
    }

    public ExpressionList<T> ne(String propertyName, Object value) {
        return this.exprList.ne(propertyName, value);
    }

    public ExpressionList<T> not(Expression exp) {
        return this.exprList.not(exp);
    }

    public ExpressionList<T> or(Expression expOne, Expression expTwo) {
        return this.exprList.or(expOne, expTwo);
    }

    public OrderBy<T> orderBy() {
        return this.exprList.orderBy();
    }

    public ExpressionList<T> orderBy(String orderBy) {
        return this.exprList.orderBy(orderBy);
    }

    public Query<T> orderById(boolean orderById) {
        return this.exprList.orderById(orderById);
    }

    public Query<T> query() {
        return this.exprList.query();
    }

    public ExpressionList<T> raw(String raw, Object value) {
        return this.exprList.raw(raw, value);
    }

    public ExpressionList<T> raw(String raw, Object ... values) {
        return this.exprList.raw(raw, values);
    }

    public ExpressionList<T> rawOrEmpty(String raw, Collection<?> values) {
        return this.exprList.rawOrEmpty(raw, values);
    }

    public ExpressionList<T> raw(String raw) {
        return this.exprList.raw(raw);
    }

    public Query<T> select(String properties) {
        return this.exprList.select(properties);
    }

    public Query<T> select(FetchGroup<T> fetchGroup) {
        return this.exprList.select(fetchGroup);
    }

    public Query<T> setDistinct(boolean distinct) {
        return this.exprList.setDistinct(distinct);
    }

    public ExpressionList<T> setFirstRow(int firstRow) {
        return this.exprList.setFirstRow(firstRow);
    }

    public Query<T> setMapKey(String mapKey) {
        return this.exprList.setMapKey(mapKey);
    }

    public ExpressionList<T> setMaxRows(int maxRows) {
        return this.exprList.setMaxRows(maxRows);
    }

    public Query<T> setUseCache(boolean useCache) {
        return this.exprList.setUseCache(useCache);
    }

    public Query<T> setBeanCacheMode(CacheMode useCache) {
        return this.exprList.setBeanCacheMode(useCache);
    }

    public Query<T> setUseQueryCache(CacheMode useCache) {
        return this.exprList.setUseQueryCache(useCache);
    }

    public Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        return this.exprList.setDisableLazyLoading(disableLazyLoading);
    }

    public Query<T> setCountDistinct(CountDistinctOrder orderBy) {
        return this.exprList.setCountDistinct(orderBy);
    }

    public Query<T> setLabel(String label) {
        return this.exprList.setLabel(label);
    }

    public ExpressionList<T> startsWith(String propertyName, String value) {
        return this.exprList.startsWith(propertyName, value);
    }

    public ExpressionList<T> where() {
        return this.exprList.where();
    }

    public Junction<T> and() {
        return this.conjunction();
    }

    public Junction<T> or() {
        return this.disjunction();
    }

    public Junction<T> not() {
        return this.exprList.not();
    }

    public Junction<T> conjunction() {
        return this.exprList.conjunction();
    }

    public Junction<T> disjunction() {
        return this.exprList.disjunction();
    }

    public ExpressionList<T> endJunction() {
        return this.exprList.endJunction();
    }

    public ExpressionList<T> endAnd() {
        return this.endJunction();
    }

    public ExpressionList<T> endOr() {
        return this.endJunction();
    }

    public ExpressionList<T> endNot() {
        return this.endJunction();
    }

    public ExpressionList<T> clear() {
        return this.exprList.clear();
    }
}

