/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Query;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.querydefn.OrmQueryLimitRequest;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.util.BindParamsParser;

final class CQueryBuilderRawSql {
    private final SqlLimiter sqlLimiter;
    private final DatabasePlatform dbPlatform;

    CQueryBuilderRawSql(SqlLimiter sqlLimiter, DatabasePlatform dbPlatform) {
        this.sqlLimiter = sqlLimiter;
        this.dbPlatform = dbPlatform;
    }

    SqlLimitResponse buildSql(OrmQueryRequest<?> request, CQueryPredicates predicates, SpiRawSql.Sql rsql) {
        if (rsql == null) {
            return new SqlLimitResponse("--ResultSetBasedRawSql");
        }
        if (!rsql.isParsed()) {
            String sql = rsql.getUnparsedSql();
            BindParams bindParams = request.query().bindParams();
            if (bindParams != null && bindParams.requiresNamedParamsPrepare()) {
                sql = BindParamsParser.parse(bindParams, sql);
            }
            return new SqlLimitResponse(sql);
        }
        String orderBy = this.orderBy(predicates, rsql);
        Object sql = this.buildMainQuery(orderBy, request, predicates, rsql);
        Query query = request.query();
        if (query.hasMaxRowsOrFirstRow() && this.sqlLimiter != null) {
            return this.sqlLimiter.limit((SqlLimitRequest)new OrmQueryLimitRequest((String)sql, orderBy, (SpiQuery<?>)query, this.dbPlatform, rsql.isDistinct() || query.isDistinct()));
        }
        String prefix = "select " + (rsql.isDistinct() ? "distinct " : "");
        sql = prefix + (String)sql;
        return new SqlLimitResponse((String)sql);
    }

    private String buildMainQuery(String orderBy, OrmQueryRequest<?> request, CQueryPredicates predicates, SpiRawSql.Sql sql) {
        String dbHaving;
        String preHaving;
        String dbWhere;
        StringBuilder sb = new StringBuilder();
        OrmQueryProperties ormQueryProperties = request.query().detail().getChunk(null, false);
        if (ormQueryProperties.hasSelectClause()) {
            boolean first = true;
            for (String selectProperty : ormQueryProperties.getIncluded()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(selectProperty);
                first = false;
            }
        } else {
            sb.append(sql.getPreFrom());
        }
        sb.append(' ');
        String s = sql.getPreWhere();
        BindParams bindParams = request.query().bindParams();
        if (bindParams != null && bindParams.requiresNamedParamsPrepare()) {
            s = BindParamsParser.parse(bindParams, s);
        }
        sb.append(s).append(' ');
        Object dynamicWhere = null;
        if (request.query().getId() != null) {
            BeanDescriptor<?> descriptor = request.descriptor();
            dynamicWhere = descriptor.idBinderIdSql(null);
        }
        if (this.hasValue(dbWhere = predicates.dbWhere())) {
            dynamicWhere = dynamicWhere == null ? dbWhere : (String)dynamicWhere + " and " + dbWhere;
        }
        if (this.hasValue((String)dynamicWhere)) {
            if (sql.isAndWhereExpr()) {
                sb.append(" and ");
            } else {
                sb.append(" where ");
            }
            sb.append((String)dynamicWhere).append(' ');
        }
        if (this.hasValue(preHaving = sql.getPreHaving())) {
            sb.append(preHaving).append(' ');
        }
        if (this.hasValue(dbHaving = predicates.dbHaving())) {
            if (sql.isAndHavingExpr()) {
                sb.append(" and ");
            } else {
                sb.append(" having ");
            }
            sb.append(dbHaving).append(' ');
        }
        if (this.hasValue(orderBy)) {
            sb.append(' ').append(sql.getOrderByPrefix()).append(' ').append(orderBy);
        }
        return sb.toString().trim();
    }

    private boolean hasValue(String s) {
        return s != null && !s.isEmpty();
    }

    private String orderBy(CQueryPredicates predicates, SpiRawSql.Sql sql) {
        String orderBy = predicates.dbOrderBy();
        if (orderBy != null) {
            return orderBy;
        }
        return sql.getOrderBy();
    }
}

