/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.bean.EntityBean;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.SpiBeanType;
import io.ebeaninternal.api.SpiBeanTypeManager;
import io.ebeaninternal.api.SpiPersistenceContext;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class DefaultPersistenceContext
implements SpiPersistenceContext {
    private final HashMap<Class<?>, ClassContext> typeCache = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private int iterateDepth;

    public void beginIterate() {
        this.lock.lock();
        try {
            ++this.iterateDepth;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endIterate() {
        this.lock.lock();
        try {
            --this.iterateDepth;
            this.expungeStaleEntries();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Class<?> rootType, Object id, Object bean) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            this.classContext(rootType).useReferences(this.iterateDepth > 0).put(id, bean);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Class<?> rootType, Object id, Object bean) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            Object object = this.classContext(rootType).useReferences(this.iterateDepth > 0).putIfAbsent(id, bean);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            Object object = this.classContext(rootType).get(id);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext.WithOption getWithOption(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            PersistenceContext.WithOption withOption = this.classContext(rootType).getWithOption(id);
            return withOption;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Class<?> rootType) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            ClassContext classMap = this.typeCache.get(rootType);
            int n = classMap == null ? 0 : classMap.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.typeCache.clear();
            this.expungeStaleEntries();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear(Class<?> rootType) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null) {
                classMap.clear();
            }
            this.expungeStaleEntries();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null && id != null) {
                classMap.deleted(id);
            }
            this.expungeStaleEntries();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null && id != null) {
                classMap.remove(id);
            }
            this.expungeStaleEntries();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> dirtyBeans(SpiBeanTypeManager manager) {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            ArrayList<Object> list = new ArrayList<Object>();
            for (ClassContext classContext : this.typeCache.values()) {
                classContext.dirtyBeans(manager, list);
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void expungeStaleEntries() {
        Reference<Object> ref;
        while ((ref = this.queue.poll()) != null) {
            ((BeanRef)ref).expunge();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            this.expungeStaleEntries();
            String string = this.typeCache.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ClassContext classContext(Class<?> rootType) {
        return this.typeCache.computeIfAbsent(rootType, k -> new ClassContext((Class<?>)k, this.queue));
    }

    private static class ClassContext {
        private final Map<Object, Object> map = new HashMap<Object, Object>();
        private final Class<?> rootType;
        private final ReferenceQueue<Object> queue;
        private Set<Object> deleteSet;
        private boolean useReferences;
        private int weakCount;

        private ClassContext(Class<?> rootType, ReferenceQueue<Object> queue) {
            this.rootType = rootType;
            this.queue = queue;
        }

        private ClassContext useReferences(boolean useReferences) {
            this.useReferences = useReferences;
            return this;
        }

        public String toString() {
            return "size:" + this.map.size() + " (" + this.weakCount + " weak)";
        }

        private Object get(Object id) {
            Object ret = this.map.get(id);
            if (ret instanceof BeanRef) {
                return ((BeanRef)ret).get();
            }
            return ret;
        }

        private PersistenceContext.WithOption getWithOption(Object id) {
            if (this.deleteSet != null && this.deleteSet.contains(id)) {
                return PersistenceContext.WithOption.DELETED;
            }
            Object bean = this.get(id);
            return bean == null ? null : new PersistenceContext.WithOption(bean);
        }

        private Object putIfAbsent(Object id, Object bean) {
            Object existingValue = this.get(id);
            if (existingValue != null) {
                return existingValue;
            }
            this.put(id, bean);
            return null;
        }

        private void put(Object id, Object bean) {
            Object existing;
            if (this.useReferences) {
                ++this.weakCount;
                existing = this.map.put(id, new BeanRef(this, id, bean, this.queue));
            } else {
                existing = this.map.put(id, bean);
            }
            if (existing instanceof BeanRef) {
                ((BeanRef)existing).setReplaced();
                --this.weakCount;
            }
        }

        private int size() {
            return this.map.size();
        }

        private void clear() {
            this.map.clear();
            this.weakCount = 0;
        }

        private void remove(Object id) {
            Object ret = this.map.remove(id);
            if (ret instanceof BeanRef) {
                --this.weakCount;
            }
        }

        private void deleted(Object id) {
            if (this.deleteSet == null) {
                this.deleteSet = new HashSet<Object>();
            }
            this.deleteSet.add(id);
            this.remove(id);
        }

        void dirtyBeans(SpiBeanTypeManager manager, List<Object> list) {
            SpiBeanType beanType = manager.beanType(this.rootType);
            for (Object value : this.map.values()) {
                EntityBean bean;
                if (value instanceof BeanRef && (value = ((BeanRef)value).get()) == null || !(bean = (EntityBean)value)._ebean_getIntercept().isDirty() && !beanType.isToManyDirty(bean)) continue;
                list.add(value);
            }
        }
    }

    private static class BeanRef
    extends WeakReference<Object> {
        private final ClassContext classContext;
        private final Object key;
        private boolean replaced;

        private BeanRef(ClassContext classContext, Object key, Object referent, ReferenceQueue<? super Object> q) {
            super(referent, q);
            this.classContext = classContext;
            this.key = key;
        }

        private void setReplaced() {
            this.replaced = true;
        }

        private void expunge() {
            if (!this.replaced) {
                this.classContext.remove(this.key);
            }
        }
    }
}

