/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.ArrayElementConverter;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.ScalarTypeArrayList;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

final class ScalarTypeArrayListH2
extends ScalarTypeArrayList {
    static PlatformArrayTypeFactory factory() {
        return new Factory();
    }

    private ScalarTypeArrayListH2(boolean nullable, String arrayType, DocPropertyType docPropertyType, ArrayElementConverter converter) {
        super(nullable, arrayType, docPropertyType, converter);
    }

    @Override
    public void bind(DataBinder binder, List value) throws SQLException {
        if (value == null) {
            this.bindNull(binder);
        } else {
            binder.setObject((Object)this.toArray(value));
        }
    }

    @Override
    protected void bindNull(DataBinder binder) throws SQLException {
        if (this.nullable) {
            binder.setNull(2003);
        } else {
            binder.setObject((Object)EMPTY_ARRAY);
        }
    }

    static class Factory
    implements PlatformArrayTypeFactory {
        private final ReentrantLock lock = new ReentrantLock();
        private final Map<String, ScalarTypeArrayListH2> cache = new HashMap<String, ScalarTypeArrayListH2>();

        Factory() {
        }

        @Override
        public ScalarType<?> typeFor(Type valueType, boolean nullable) {
            this.lock.lock();
            try {
                String key = String.valueOf(valueType) + ":" + nullable;
                if (valueType.equals(UUID.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "uuid", DocPropertyType.UUID, ArrayElementConverter.UUID));
                    return scalarType;
                }
                if (valueType.equals(Long.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "bigint", DocPropertyType.LONG, ArrayElementConverter.LONG));
                    return scalarType;
                }
                if (valueType.equals(Integer.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "integer", DocPropertyType.INTEGER, ArrayElementConverter.INTEGER));
                    return scalarType;
                }
                if (valueType.equals(Float.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "real", DocPropertyType.DOUBLE, ArrayElementConverter.FLOAT));
                    return scalarType;
                }
                if (valueType.equals(Double.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "float", DocPropertyType.DOUBLE, ArrayElementConverter.DOUBLE));
                    return scalarType;
                }
                if (valueType.equals(BigDecimal.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "float", DocPropertyType.DOUBLE, ArrayElementConverter.BIG_DECIMAL));
                    return scalarType;
                }
                if (valueType.equals(String.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "varchar", DocPropertyType.TEXT, ArrayElementConverter.STRING));
                    return scalarType;
                }
                if (valueType.equals(Instant.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "timestamp", DocPropertyType.TEXT, ArrayElementConverter.INSTANT));
                    return scalarType;
                }
                if (valueType.equals(LocalDate.class)) {
                    ScalarType scalarType = (ScalarType)this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayListH2(nullable, "date", DocPropertyType.TEXT, ArrayElementConverter.LOCAL_DATE));
                    return scalarType;
                }
                throw new IllegalArgumentException("Type [" + String.valueOf(valueType) + "] not supported for @DbArray mapping");
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public ScalarType<?> typeForEnum(ScalarType<?> scalarType, boolean nullable) {
            return new ScalarTypeArrayListH2(nullable, "varchar", DocPropertyType.TEXT, new ArrayElementConverter.EnumConverter(scalarType));
        }
    }
}

