/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CallableSql;
import io.ebean.Database;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiCallableSql;
import io.ebeaninternal.api.TransactionEventTable;
import java.io.Serializable;
import java.sql.CallableStatement;

final class DefaultCallableSql
implements Serializable,
SpiCallableSql {
    private static final long serialVersionUID = 8984272253185424701L;
    private final TransactionEventTable transactionEvent = new TransactionEventTable();
    private final BindParams bindParameters = new BindParams();
    private final transient Database server;
    private String sql;
    private String label;
    private int timeout;

    DefaultCallableSql(Database server, String sql) {
        this.server = server;
        this.sql = sql;
    }

    public void execute() {
        this.server.execute((CallableSql)this, null);
    }

    public String getLabel() {
        return this.label;
    }

    public CallableSql setLabel(String label) {
        this.label = label;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getSql() {
        return this.sql;
    }

    public CallableSql setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    public CallableSql setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public CallableSql bind(int position, Object value) {
        this.bindParameters.setParameter(position, value);
        return this;
    }

    public CallableSql setParameter(int position, Object value) {
        this.bindParameters.setParameter(position, value);
        return this;
    }

    public CallableSql registerOut(int position, int type) {
        this.bindParameters.registerOut(position, type);
        return this;
    }

    public Object getObject(int position) {
        BindParams.Param p = this.bindParameters.parameter(position);
        return p.outValue();
    }

    public boolean executeOverride(CallableStatement statement) {
        return false;
    }

    public CallableSql addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.transactionEvent.add(tableName, inserts, updates, deletes);
        return this;
    }

    @Override
    public TransactionEventTable transactionEventTable() {
        return this.transactionEvent;
    }

    @Override
    public BindParams bindParams() {
        return this.bindParameters;
    }
}

