/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CacheMode;
import io.ebean.CancelableQuery;
import io.ebean.OrderBy;
import io.ebean.PersistenceContextScope;
import io.ebean.QueryIterator;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.PersistenceContext;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.common.BeanList;
import io.ebean.common.BeanMap;
import io.ebean.common.CopyOnFirstWriteList;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.CacheIdLookup;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.HashQuery;
import io.ebeaninternal.api.LoadContext;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.NaturalKeySet;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQueryManyJoin;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.BeanRequest;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.deploy.DeployPropertyParserMap;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import jakarta.persistence.PersistenceException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class OrmQueryRequest<T>
extends BeanRequest
implements SpiOrmQueryRequest<T> {
    private final BeanDescriptor<T> beanDescriptor;
    private final OrmQueryEngine queryEngine;
    private final SpiQuery<T> query;
    private final BeanFindController finder;
    private LoadContext loadContext;
    private PersistenceContext persistenceContext;
    private HashQuery cacheKey;
    private CQueryPlanKey queryPlanKey;
    private SpiQuerySecondary secondaryQueries;
    private List<T> cacheBeans;
    private boolean inlineCountDistinct;
    private Set<String> dependentTables;
    private SpiQueryManyJoin manyJoin;

    public OrmQueryRequest(SpiEbeanServer server, OrmQueryEngine queryEngine, SpiQuery<T> query, SpiTransaction t) {
        super(server, t);
        this.beanDescriptor = query.descriptor();
        this.finder = this.beanDescriptor.beanFinder();
        this.queryEngine = queryEngine;
        this.query = query;
        this.persistenceContext = query.persistenceContext();
    }

    public PersistenceException translate(String bindLog, String sql, SQLException e) {
        return this.queryEngine.translate(this, bindLog, sql, e);
    }

    @Override
    public boolean isGetAllFromBeanCache() {
        return (this.transaction == null || !this.transaction.isSkipCache()) && this.getFromBeanCache();
    }

    @Override
    public boolean isDeleteByStatement() {
        if (!this.transaction.isPersistCascade() || this.beanDescriptor.isDeleteByStatement()) {
            return true;
        }
        this.queryPlanKey = this.query.setDeleteByIdsPlan();
        return false;
    }

    public boolean isPadInExpression() {
        return this.beanDescriptor.isPadInExpression();
    }

    public boolean isMultiValueIdSupported() {
        return this.beanDescriptor.isMultiValueIdSupported();
    }

    public boolean isMultiValueSupported(Class<?> valueType) {
        return this.queryEngine.isMultiValueSupported(valueType);
    }

    @Override
    public void markNotQueryOnly() {
        this.transaction.markNotQueryOnly();
    }

    @Override
    public String dbLikeClause(boolean rawLikeExpression) {
        return this.server.databasePlatform().likeClause(rawLikeExpression);
    }

    @Override
    public String escapeLikeString(String value) {
        return this.server.databasePlatform().escapeLikeString(value);
    }

    public void executeSecondaryQueries(boolean forEach) {
        if (this.loadContext != null) {
            this.loadContext.executeSecondaryQueries(this, forEach);
        }
    }

    public int secondaryQueriesMinBatchSize() {
        return this.loadContext.secondaryQueriesMinBatchSize();
    }

    @Override
    public BeanDescriptor<T> descriptor() {
        return this.beanDescriptor;
    }

    public LoadContext loadContext() {
        return this.loadContext;
    }

    private void adapterPreQuery() {
        BeanQueryAdapter queryAdapter = this.beanDescriptor.queryAdapter();
        if (queryAdapter != null) {
            queryAdapter.preQuery((BeanQueryRequest)this);
        }
    }

    @Override
    public void prepareQuery() {
        this.manyJoin = this.query.convertJoins();
        this.secondaryQueries = this.query.secondaryQuery();
        this.beanDescriptor.prepareQuery(this.query);
        this.adapterPreQuery();
        this.queryPlanKey = this.query.prepare(this);
    }

    public boolean isNativeSql() {
        return this.query.isNativeSql();
    }

    public boolean isRawSql() {
        return this.query.isRawSql();
    }

    public DeployParser createDeployParser() {
        if (this.query.isRawSql()) {
            return new DeployPropertyParserMap(this.query.rawSql().getColumnMapping().getMapping());
        }
        return this.beanDescriptor.parser();
    }

    public PersistenceContext persistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void initTransIfRequired() {
        if (this.transaction == null) {
            this.transaction = this.query.type().isUpdate() ? this.server.beginServerTransaction() : this.server.createReadOnlyTransaction(this.query.tenantId(), this.query.isUseMaster());
            this.createdTransaction = true;
        }
        this.persistenceContext = this.persistenceContext(this.query, this.transaction);
        if (SpiQuery.Type.ITERATE == this.query.type()) {
            this.persistenceContext.beginIterate();
        }
        this.loadContext = new DLoadContext(this, this.secondaryQueries);
    }

    @Override
    public void rollbackTransIfRequired() {
        if (SpiQuery.Type.ITERATE == this.query.type()) {
            this.persistenceContext.endIterate();
        }
        if (this.createdTransaction) {
            try {
                this.transaction.end();
            }
            catch (Exception e) {
                CoreLog.log.log(System.Logger.Level.ERROR, "Error trying to rollback a transaction (after a prior exception thrown)", (Throwable)e);
            }
        }
    }

    private PersistenceContext persistenceContext(SpiQuery<?> query, SpiTransaction t) {
        PersistenceContext ctx = query.persistenceContext();
        if (ctx != null) {
            return ctx;
        }
        PersistenceContextScope scope = this.server.persistenceContextScope(query);
        if (scope == PersistenceContextScope.QUERY || t == null) {
            return new DefaultPersistenceContext();
        }
        return t.persistenceContext();
    }

    @Override
    public void endTransIfRequired() {
        if (SpiQuery.Type.ITERATE == this.query.type()) {
            this.persistenceContext.endIterate();
        }
        if (this.createdTransaction && this.transaction.isActive()) {
            this.transaction.commit();
            if (this.query.type().isUpdate()) {
                this.server.clearServerTransaction();
            }
        }
    }

    public boolean isFindById() {
        return this.query.type() == SpiQuery.Type.BEAN;
    }

    public boolean isFindIterate() {
        return this.query.type() == SpiQuery.Type.ITERATE;
    }

    @Override
    public int delete() {
        return this.notifyCache(this.queryEngine.delete(this), false);
    }

    @Override
    public int update() {
        return this.notifyCache(this.queryEngine.update(this), true);
    }

    private int notifyCache(int rows, boolean update) {
        if (rows > 0) {
            this.beanDescriptor.cacheUpdateQuery(update, this.transaction);
        }
        return rows;
    }

    @Override
    public SpiResultSet findResultSet() {
        return this.queryEngine.findResultSet(this);
    }

    @Override
    public Object findId() {
        return this.queryEngine.findId(this);
    }

    @Override
    public int findCount() {
        return this.queryEngine.findCount(this);
    }

    @Override
    public <A> List<A> findIds() {
        return this.queryEngine.findIds(this);
    }

    @Override
    public void findEach(Consumer<T> consumer) {
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext()) {
                consumer.accept(it.next());
            }
        }
    }

    @Override
    public void findEach(int batch, Consumer<List<T>> batchConsumer) {
        ArrayList<Object> buffer = new ArrayList<Object>(batch);
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext()) {
                buffer.add(it.next());
                if (buffer.size() < batch) continue;
                batchConsumer.accept(buffer);
                buffer.clear();
            }
            if (!buffer.isEmpty()) {
                batchConsumer.accept(buffer);
            }
        }
    }

    @Override
    public void findEachWhile(Predicate<T> consumer) {
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext() && consumer.test(it.next())) {
            }
        }
    }

    @Override
    public QueryIterator<T> findIterate() {
        return this.queryEngine.findIterate(this);
    }

    @Override
    public List<T> findList() {
        return (List)this.queryEngine.findMany(this);
    }

    @Override
    public List<Version<T>> findVersions() {
        return this.queryEngine.findVersions(this);
    }

    @Override
    public Set<T> findSet() {
        return (Set)this.queryEngine.findMany(this);
    }

    @Override
    public <K> Map<K, T> findMap() {
        String mapKey = this.query.mapKey();
        if (mapKey == null) {
            BeanProperty idProp = this.beanDescriptor.idProperty();
            if (idProp != null) {
                this.query.setMapKey(idProp.name());
            } else {
                throw new PersistenceException("No mapKey specified for query");
            }
        }
        return (Map)this.queryEngine.findMany(this);
    }

    @Override
    public <A extends Collection<?>> A findSingleAttributeCollection(A collection) {
        return this.queryEngine.findSingleAttributeCollection(this, collection);
    }

    public BeanFindController finder() {
        return this.finder;
    }

    @Override
    public SpiQuery<T> query() {
        return this.query;
    }

    public SpiQueryManyJoin manyJoin() {
        return this.manyJoin;
    }

    public boolean includeManyJoin() {
        if (this.manyJoin == null || this.query.isSingleAttribute()) {
            return false;
        }
        SpiQuery.Type type = this.query.type();
        return type != SpiQuery.Type.SQ_EX && type != SpiQuery.Type.COUNT;
    }

    public CQueryPlan queryPlan() {
        return this.beanDescriptor.queryPlan(this.queryPlanKey);
    }

    public CQueryPlanKey queryPlanKey() {
        return this.queryPlanKey;
    }

    public void putQueryPlan(CQueryPlan queryPlan) {
        this.beanDescriptor.queryPlan(this.queryPlanKey, queryPlan);
    }

    @Override
    public void resetBeanCacheAutoMode(boolean findOne) {
        this.query.resetBeanCacheAutoMode(findOne);
    }

    public boolean isQueryCachePut() {
        return this.cacheKey != null && this.query.queryCacheMode().isPut();
    }

    public boolean isBeanCachePutMany() {
        return !this.transaction.isSkipCacheExplicit() && this.query.isBeanCachePut();
    }

    public boolean isBeanCachePut() {
        return !this.transaction.isSkipCache() && this.query.isBeanCachePut();
    }

    public void mergeCacheHits(BeanCollection<T> result) {
        if (this.cacheBeans != null && !this.cacheBeans.isEmpty()) {
            if (this.query.type() == SpiQuery.Type.MAP) {
                this.mergeCacheHitsToMap(result);
            } else {
                this.mergeCacheHitsToCollection(result);
            }
        }
    }

    private void mergeCacheHitsToCollection(BeanCollection<T> result) {
        OrderBy<T> orderBy;
        for (T hit : this.cacheBeans) {
            result.internalAdd(hit);
        }
        if (result instanceof BeanList && (orderBy = this.query.getOrderBy()) != null && !orderBy.isEmpty()) {
            this.beanDescriptor.sort(((BeanList)result).actualList(), orderBy.toStringFormat());
        }
    }

    private void mergeCacheHitsToMap(BeanCollection<T> result) {
        BeanMap map = (BeanMap)result;
        ElPropertyValue property = this.mapProperty();
        for (T bean : this.cacheBeans) {
            map.internalPut(property.pathGet(bean), bean);
        }
    }

    @Override
    public List<T> beanCacheHits() {
        OrderBy<T> orderBy = this.query.getOrderBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            this.beanDescriptor.sort(this.cacheBeans, orderBy.toStringFormat());
        }
        return this.cacheBeans;
    }

    @Override
    public <K> Map<K, T> beanCacheHitsAsMap() {
        OrderBy<T> orderBy = this.query.getOrderBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            this.beanDescriptor.sort(this.cacheBeans, orderBy.toStringFormat());
        }
        return this.cacheBeansToMap();
    }

    private <K> Map<K, T> cacheBeansToMap() {
        ElPropertyValue property = this.mapProperty();
        LinkedHashMap<Object, T> map = new LinkedHashMap<Object, T>();
        for (T bean : this.cacheBeans) {
            map.put(property.pathGet(bean), bean);
        }
        return map;
    }

    private ElPropertyValue mapProperty() {
        ElPropertyValue property;
        String key = this.query.mapKey();
        ElPropertyValue elPropertyValue = property = key == null ? this.beanDescriptor.idProperty() : this.beanDescriptor.elGetValue(key);
        if (property == null) {
            throw new IllegalStateException("Unknown map key property " + key);
        }
        return property;
    }

    @Override
    public Set<T> beanCacheHitsAsSet() {
        OrderBy<T> orderBy = this.query.getOrderBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            this.beanDescriptor.sort(this.cacheBeans, orderBy.toStringFormat());
        }
        return new LinkedHashSet<T>(this.cacheBeans);
    }

    @Override
    public boolean getFromBeanCache() {
        NaturalKeySet naturalKeySet;
        if (!this.query.isBeanCacheGet()) {
            return false;
        }
        CacheIdLookup<T> idLookup = this.query.cacheIdLookup();
        if (idLookup != null) {
            BeanCacheResult<T> cacheResult = this.beanDescriptor.cacheIdLookup(this.persistenceContext, idLookup.idValues());
            this.cacheBeans = idLookup.removeHits(cacheResult);
            return idLookup.allHits();
        }
        if (!this.beanDescriptor.isNaturalKeyCaching()) {
            return false;
        }
        NaturalKeyQueryData<T> data = this.query.naturalKey();
        if (data != null && (naturalKeySet = data.buildKeys()) != null) {
            BeanCacheResult<T> cacheResult = this.beanDescriptor.naturalKeyLookup(this.persistenceContext, naturalKeySet.keys());
            this.cacheBeans = data.removeHits(cacheResult);
            return data.allHits();
        }
        return false;
    }

    @Override
    public Object getFromQueryCache() {
        if (this.query.queryCacheMode() == CacheMode.OFF || this.transaction != null && this.transaction.isSkipCache() || this.server.isDisableL2Cache()) {
            return null;
        }
        this.cacheKey = this.query.queryHash();
        if (!this.query.queryCacheMode().isGet()) {
            return null;
        }
        Cloneable cached = this.beanDescriptor.queryCacheGet(this.cacheKey);
        if (Boolean.FALSE.equals(this.query.isReadOnly())) {
            if (cached instanceof BeanCollection) {
                cached = ((BeanCollection)cached).shallowCopy();
            } else if (cached instanceof List) {
                cached = new CopyOnFirstWriteList((List)((Object)cached));
            } else if (cached instanceof Set) {
                cached = new LinkedHashSet(cached);
            } else if (cached instanceof Map) {
                cached = new LinkedHashMap((Map)((Object)cached));
            }
        }
        return cached;
    }

    public void putToQueryCache(Object result) {
        this.beanDescriptor.queryCachePut(this.cacheKey, new QueryCacheEntry(result, this.dependentTables, this.transaction.startNanoTime()));
    }

    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        this.query.setCancelableQuery(cancelableQuery);
    }

    public void logSql(String msg, Object ... args) {
        this.transaction.logSql(msg, args);
    }

    public int lazyLoadBatchSize() {
        int batchSize = this.query.lazyLoadBatchSize();
        return batchSize > 0 ? batchSize : this.server.lazyLoadBatchSize();
    }

    public String baseTableAlias() {
        return this.query.getAlias(this.beanDescriptor.baseTableAlias());
    }

    public void setDefaultFetchBuffer(int fetchSize) {
        this.query.setDefaultFetchBuffer(fetchSize);
    }

    public Object tenantId() {
        return this.transaction == null ? null : this.transaction.tenantId();
    }

    public void slowQueryCheck(long executionTimeMicros, int rowCount) {
        this.server.slowQueryCheck(executionTimeMicros, rowCount, this.query);
    }

    public void setInlineCountDistinct() {
        this.inlineCountDistinct = true;
    }

    public boolean isInlineCountDistinct() {
        return this.inlineCountDistinct;
    }

    public void addDependentTables(Set<String> tables) {
        if (tables != null && !tables.isEmpty()) {
            if (this.dependentTables == null) {
                this.dependentTables = new LinkedHashSet<String>();
            }
            this.dependentTables.addAll(tables);
        }
    }

    public boolean isInlineSqlUpdateLimit() {
        return this.query.getMaxRows() < 1 || this.server.databasePlatform().inlineSqlUpdateLimit();
    }

    public int forwardOnlyFetchSize() {
        return this.queryEngine.forwardOnlyFetchSize();
    }

    public void clearContext() {
        if (!this.transaction.isAutoPersistUpdates()) {
            this.beanDescriptor.contextClear(this.transaction.persistenceContext());
        }
    }
}

