/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.avaje.applog.AppLog;
import io.ebeaninternal.server.executor.DaemonThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

final class DaemonExecutorService {
    private static final System.Logger logger = AppLog.getLogger(DaemonExecutorService.class);
    private final ReentrantLock lock = new ReentrantLock(false);
    private final String namePrefix;
    private final int shutdownWaitSeconds;
    private final ExecutorService service;

    DaemonExecutorService(int shutdownWaitSeconds, String namePrefix) {
        this.service = Executors.newCachedThreadPool(new DaemonThreadFactory(namePrefix));
        this.shutdownWaitSeconds = shutdownWaitSeconds;
        this.namePrefix = namePrefix;
    }

    <T> Future<T> submit(Callable<T> task) {
        return this.service.submit(task);
    }

    Future<?> submit(Runnable task) {
        return this.service.submit(task);
    }

    void shutdown() {
        this.lock.lock();
        try {
            if (this.service.isShutdown()) {
                logger.log(System.Logger.Level.DEBUG, "DaemonExecutorService[{0}] already shut down", this.namePrefix);
                return;
            }
            try {
                logger.log(System.Logger.Level.DEBUG, "DaemonExecutorService[{0}] shutting down...", this.namePrefix);
                this.service.shutdown();
                if (!this.service.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    logger.log(System.Logger.Level.INFO, "DaemonExecutorService[{0}] shut down timeout exceeded. Terminating running threads.", this.namePrefix);
                    this.service.shutdownNow();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error during shutdown of DaemonThreadPool[" + this.namePrefix + "]", (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

