/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.DmlUtil;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.InsertMeta;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class InsertHandler
extends DmlHandler {
    private final InsertMeta meta;
    private final boolean concatenatedKey;
    private boolean useGeneratedKeys;
    private boolean useSelectLastInsertedId;

    public InsertHandler(PersistRequestBean<?> persist, InsertMeta meta) {
        super(persist);
        this.meta = meta;
        this.concatenatedKey = meta.isConcatenatedKey();
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public void bind() throws SQLException {
        boolean withId;
        EntityBean bean;
        BeanDescriptor desc = this.persistRequest.descriptor();
        Object idValue = desc.getId(bean = this.persistRequest.entityBean());
        boolean bl = withId = !DmlUtil.isNullOrZero(idValue);
        if (!withId) {
            if (this.concatenatedKey) {
                withId = this.meta.deriveConcatenatedId(this.persistRequest);
            } else if (this.meta.supportsGetGeneratedKeys()) {
                this.useGeneratedKeys = true;
            } else {
                this.useSelectLastInsertedId = this.meta.supportsSelectLastInsertedId();
            }
        }
        Transaction t = this.persistRequest.transaction();
        this.sql = this.meta.sql(withId, this.persistRequest.insertOptions());
        PreparedStatement pstmt = this.persistRequest.isBatched() ? this.pstmtBatch((SpiTransaction)t, this.sql, this.persistRequest, this.useGeneratedKeys) : this.pstmt((SpiTransaction)t, this.sql, this.useGeneratedKeys);
        this.dataBind = this.bind(pstmt);
        this.meta.bind(this, bean, withId);
        if (this.persistRequest.isBatched()) {
            this.batchedPstmt.registerInputStreams(this.dataBind.getInputStreams());
        }
        this.logSql(this.sql);
    }

    @Override
    PreparedStatement pstmt(SpiTransaction t, String sql, boolean useGeneratedKeys) throws SQLException {
        Connection conn = t.internalConnection();
        if (useGeneratedKeys) {
            return conn.prepareStatement(sql, this.meta.identityDbColumns());
        }
        return conn.prepareStatement(sql);
    }

    @Override
    public int execute() throws SQLException, OptimisticLockException {
        int rowCount = this.dataBind.executeUpdate();
        if (this.useGeneratedKeys) {
            this.getGeneratedKeys();
        } else if (this.useSelectLastInsertedId) {
            this.fetchGeneratedKeyUsingSelect();
        }
        this.checkRowCount(rowCount);
        return rowCount;
    }

    private void getGeneratedKeys() throws SQLException {
        ResultSet rset = this.dataBind.getPstmt().getGeneratedKeys();
        try {
            this.setGeneratedKey(rset);
        }
        finally {
            JdbcClose.close((ResultSet)rset);
        }
    }

    private void setGeneratedKey(ResultSet rset) throws SQLException {
        if (rset.next()) {
            Object idValue = rset.getObject(1);
            if (idValue != null) {
                this.persistRequest.setGeneratedKey(idValue);
            }
        } else if (this.persistRequest.insertOptions() == null) {
            throw new PersistenceException("Autoincrement getGeneratedKeys() returned no rows?");
        }
    }

    private void fetchGeneratedKeyUsingSelect() throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = this.transaction.connection().prepareStatement(this.persistRequest.selectLastInsertedId());
            rset = stmt.executeQuery();
            this.setGeneratedKey(rset);
        }
        catch (Throwable throwable) {
            JdbcClose.close(rset);
            JdbcClose.close(stmt);
            throw throwable;
        }
        JdbcClose.close((ResultSet)rset);
        JdbcClose.close((Statement)stmt);
    }
}

