/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.InsertOptions;
import io.ebean.annotation.Platform;
import io.ebean.bean.EntityBean;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dml.InsertMetaOptions;
import io.ebeaninternal.server.persist.dml.InsertMetaPlatform;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;

final class InsertMeta {
    private final String sqlNullId;
    private final String sqlWithId;
    private final BindableId id;
    private final BindableList all;
    private final boolean supportsGetGeneratedKeys;
    private final boolean concatenatedKey;
    private final boolean supportsSelectLastInsertedId;
    private final Bindable shadowFKey;
    private final String[] identityDbColumns;
    private final Platform platform;
    private final InsertMetaOptions options;

    InsertMeta(DatabasePlatform dbPlatform, BeanDescriptor<?> desc, Bindable shadowFKey, BindableId id, BindableList all) {
        this.platform = dbPlatform.platform();
        this.options = InsertMetaPlatform.create(this.platform, desc, this);
        this.id = id;
        this.all = all;
        this.shadowFKey = shadowFKey;
        String tableName = desc.baseTable();
        this.sqlWithId = this.sql(false, tableName);
        if (id.isConcatenated()) {
            this.concatenatedKey = true;
            this.identityDbColumns = null;
            this.sqlNullId = null;
            this.supportsGetGeneratedKeys = false;
            this.supportsSelectLastInsertedId = false;
        } else {
            this.concatenatedKey = false;
            if (id.getIdentityColumn() == null) {
                this.identityDbColumns = new String[0];
                this.supportsGetGeneratedKeys = false;
                this.supportsSelectLastInsertedId = false;
            } else {
                this.identityDbColumns = new String[]{id.getIdentityColumn()};
                this.supportsGetGeneratedKeys = dbPlatform.dbIdentity().isSupportsGetGeneratedKeys();
                this.supportsSelectLastInsertedId = desc.supportsSelectLastInsertedId();
            }
            this.sqlNullId = this.sql(true, tableName);
        }
    }

    boolean isConcatenatedKey() {
        return this.concatenatedKey;
    }

    String[] identityDbColumns() {
        return this.identityDbColumns;
    }

    boolean supportsSelectLastInsertedId() {
        return this.supportsSelectLastInsertedId;
    }

    boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        return this.id.deriveConcatenatedId(persist);
    }

    public void bind(DmlHandler request, EntityBean bean, boolean withId) throws SQLException {
        if (withId) {
            this.id.dmlBind(request, bean);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlBind(request, bean);
        }
        this.all.dmlBind(request, bean);
    }

    public String sql(boolean withId, InsertOptions insertOptions) {
        if (insertOptions == null) {
            return this.sqlFor(withId);
        }
        return this.options.sql(withId, insertOptions);
    }

    String sqlFor(boolean withId) {
        return withId ? this.sqlWithId : this.sqlNullId;
    }

    private String sql(boolean nullId, String table) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        this.sql(request, nullId, table);
        return request.toString();
    }

    void sql(GenerateDmlRequest request, boolean nullId, String table) {
        request.setInsertSetMode();
        request.append("insert into ").append(table);
        if (nullId && this.noColumnsForInsert()) {
            request.append(this.defaultValues());
            return;
        }
        request.append(" (");
        if (!nullId) {
            this.id.dmlAppend(request);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlAppend(request);
        }
        this.all.dmlAppend(request);
        request.append(") values (");
        request.append(request.insertBindBuffer());
        request.append(")");
    }

    private String defaultValues() {
        switch (this.platform.base()) {
            case MYSQL: 
            case MARIADB: 
            case ORACLE: {
                return " values (default)";
            }
            case DB2: {
                return " (" + this.id.getIdentityColumn() + ") values (default)";
            }
        }
        return " default values";
    }

    private boolean noColumnsForInsert() {
        return this.shadowFKey == null && this.all.isEmpty();
    }
}

