/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.sql.Array;
import java.sql.SQLException;

abstract class ScalarTypeArrayBase<T>
extends ScalarTypeJsonCollection<T> {
    static final Object[] EMPTY_ARRAY = new Object[0];

    ScalarTypeArrayBase(Class<T> type, int dbType, DocPropertyType docPropertyType, boolean nullable) {
        super(type, dbType, docPropertyType, nullable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(DataReader reader) throws SQLException {
        Array array = reader.getArray();
        if (array == null) {
            return null;
        }
        try {
            T t = this.fromArray(this.convertArray(array.getArray()));
            return t;
        }
        finally {
            array.free();
        }
    }

    private Object[] convertArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof long[]) {
            return this.convertLongs((long[])array);
        }
        if (array instanceof int[]) {
            return this.convertInts((int[])array);
        }
        if (array instanceof double[]) {
            return this.convertDoubles((double[])array);
        }
        throw new IllegalArgumentException("Unable to convert array " + String.valueOf(array));
    }

    private Object[] convertLongs(long[] o) {
        Object[] list = new Long[o.length];
        for (int i = 0; i < o.length; ++i) {
            list[i] = o[i];
        }
        return list;
    }

    private Object[] convertInts(int[] o) {
        Object[] list = new Integer[o.length];
        for (int i = 0; i < o.length; ++i) {
            list[i] = o[i];
        }
        return list;
    }

    private Object[] convertDoubles(double[] o) {
        Object[] list = new Double[o.length];
        for (int i = 0; i < o.length; ++i) {
            list[i] = o[i];
        }
        return list;
    }

    protected abstract T fromArray(Object[] var1);

    static String arrayTypeFor(ScalarType<?> scalarType) {
        switch (scalarType.jdbcType()) {
            case 4: {
                return "integer";
            }
            case 12: {
                return "varchar";
            }
        }
        throw new IllegalArgumentException("JdbcType [" + scalarType.jdbcType() + "] not supported for @DbArray mapping on set.");
    }
}

