/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebean.meta.MetricVisitor;
import io.ebeaninternal.server.dto.DtoMappingRequest;
import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoQueryPlan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DtoBeanDescriptor<T> {
    private final Map<Object, DtoQueryPlan> plans = new ConcurrentHashMap<Object, DtoQueryPlan>();
    private final Class<T> dtoType;
    private final DtoMeta meta;

    DtoBeanDescriptor(Class<T> dtoType, DtoMeta meta) {
        this.dtoType = dtoType;
        this.meta = meta;
    }

    public Class<T> type() {
        return this.dtoType;
    }

    public DtoQueryPlan queryPlan(Object planKey) {
        return this.plans.get(planKey);
    }

    public DtoQueryPlan buildPlan(DtoMappingRequest request) {
        return this.meta.match(request);
    }

    public void putQueryPlan(Object planKey, DtoQueryPlan plan) {
        this.plans.put(planKey, plan);
    }

    public void visit(MetricVisitor visitor) {
        for (DtoQueryPlan plan : this.plans.values()) {
            plan.visit(visitor);
        }
    }
}

