/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.NamedParamHelp;

final class InRangeExpression
extends AbstractExpression {
    private final Object valueHigh;
    private final Object valueLow;

    InRangeExpression(String propertyName, Object valueLow, Object valueHigh) {
        super(propertyName);
        this.valueLow = valueLow;
        this.valueHigh = valueHigh;
    }

    private Object low() {
        return NamedParamHelp.value(this.valueLow);
    }

    private Object high() {
        return NamedParamHelp.value(this.valueHigh);
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.beanProperty().encryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
            request.addBindValue(this.low());
            request.addBindEncryptKey(encryptKey);
            request.addBindValue(this.high());
            return;
        }
        request.addBindValue(this.low());
        request.addBindValue(this.high());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.beanProperty().decryptProperty(this.propName);
        }
        request.append('(').property(pname).append(" >= ? and ").property(pname).append(" < ?)");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("InRange[").append(this.propName).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.low()).add(this.high());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InRangeExpression that = (InRangeExpression)other;
        return this.low().equals(that.low()) && this.high().equals(that.high());
    }
}

