/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.Expression;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;

abstract class LogicExpression
implements SpiExpression {
    static final String AND = " and ";
    static final String OR = " or ";
    SpiExpression expOne;
    SpiExpression expTwo;
    private final boolean conjunction;

    LogicExpression(boolean conjunction, Expression expOne, Expression expTwo) {
        this.conjunction = conjunction;
        this.expOne = (SpiExpression)expOne;
        this.expTwo = (SpiExpression)expTwo;
    }

    @Override
    public void prefixProperty(String path) {
        this.expOne.prefixProperty(path);
        this.expTwo.prefixProperty(path);
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        boolean parentOuterJoins = manyWhereJoin.isRequireOuterJoins();
        if (!this.conjunction) {
            manyWhereJoin.setRequireOuterJoins(true);
        }
        this.expOne.containsMany(desc, manyWhereJoin);
        this.expTwo.containsMany(desc, manyWhereJoin);
        if (!this.conjunction && !parentOuterJoins) {
            manyWhereJoin.setRequireOuterJoins(false);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        this.expOne.validate(validation);
        this.expTwo.validate(validation);
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        this.expOne.addBindValues(request);
        this.expTwo.addBindValues(request);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append('(');
        this.expOne.addSql(request);
        request.append(this.conjunction ? AND : OR);
        this.expTwo.addSql(request);
        request.append(')');
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.expOne.prepareExpression(request);
        this.expTwo.prepareExpression(request);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Logic").append(this.conjunction ? AND : OR).append('[');
        this.expOne.queryPlanHash(builder);
        builder.append(',');
        this.expTwo.queryPlanHash(builder);
        builder.append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.expOne).add(this.expTwo);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        LogicExpression that = (LogicExpression)other;
        return this.expOne.isSameByBind(that.expOne) && this.expTwo.isSameByBind(that.expTwo);
    }

    static final class Or
    extends LogicExpression {
        Or(Expression expOne, Expression expTwo) {
            super(false, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new Or(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }

    static final class And
    extends LogicExpression {
        And(Expression expOne, Expression expTwo) {
            super(true, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new And(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }
}

