/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.StringHelper;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.BeanPersister;
import io.ebeaninternal.server.persist.dml.DeleteHandler;
import io.ebeaninternal.server.persist.dml.DeleteMeta;
import io.ebeaninternal.server.persist.dml.InsertHandler;
import io.ebeaninternal.server.persist.dml.InsertMeta;
import io.ebeaninternal.server.persist.dml.PersistHandler;
import io.ebeaninternal.server.persist.dml.UpdateHandler;
import io.ebeaninternal.server.persist.dml.UpdateMeta;
import java.sql.SQLException;

final class DmlBeanPersister
implements BeanPersister {
    private final DatabasePlatform dbPlatform;
    private final UpdateMeta updateMeta;
    private final InsertMeta insertMeta;
    private final DeleteMeta deleteMeta;

    DmlBeanPersister(DatabasePlatform dbPlatform, UpdateMeta updateMeta, InsertMeta insertMeta, DeleteMeta deleteMeta) {
        this.dbPlatform = dbPlatform;
        this.updateMeta = updateMeta;
        this.insertMeta = insertMeta;
        this.deleteMeta = deleteMeta;
    }

    @Override
    public int delete(PersistRequestBean<?> request) {
        return this.execute(request, new DeleteHandler(request, this.deleteMeta));
    }

    @Override
    public void insert(PersistRequestBean<?> request) {
        this.execute(request, new InsertHandler(request, this.insertMeta));
    }

    @Override
    public void update(PersistRequestBean<?> request) {
        this.execute(request, new UpdateHandler(request, this.updateMeta));
    }

    private int execute(PersistRequestBean<?> request, PersistHandler handler) {
        boolean batched = request.isBatched();
        try {
            handler.bind();
            if (batched) {
                handler.addBatch();
                int n = -1;
                return n;
            }
            int n = handler.executeNoBatch();
            return n;
        }
        catch (SQLException e) {
            String msg = "Error: " + StringHelper.removeNewLines((String)e.getMessage());
            if (request.transaction().isLogSummary()) {
                request.transaction().logSummary(msg, new Object[0]);
            }
            throw this.dbPlatform.translate(msg, e);
        }
        finally {
            if (!batched) {
                handler.close();
            }
        }
    }
}

