/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.DbReadContext;

public final class SqlBeanLoad {
    private final DbReadContext ctx;
    private final EntityBean bean;
    private final EntityBeanIntercept ebi;
    private final Class<?> type;
    private final boolean lazyLoading;
    private final boolean rawSql;

    SqlBeanLoad(DbReadContext ctx, Class<?> type, EntityBean bean, SpiQuery.Mode queryMode) {
        this.ctx = ctx;
        this.rawSql = ctx.isRawSql();
        this.type = type;
        this.lazyLoading = queryMode == SpiQuery.Mode.LAZYLOAD_BEAN;
        this.bean = bean;
        this.ebi = bean == null ? null : bean._ebean_getIntercept();
    }

    public boolean isLazyLoad() {
        return this.lazyLoading;
    }

    public DbReadContext ctx() {
        return this.ctx;
    }

    public Object load(BeanProperty prop) {
        if (!this.rawSql && !prop.isLoadProperty()) {
            return null;
        }
        if (this.bean == null || this.lazyLoading && this.ebi.isLoadedProperty(prop.propertyIndex()) || this.type != null && !prop.isAssignableFrom(this.type)) {
            prop.loadIgnore(this.ctx);
            return null;
        }
        try {
            return prop.readSet(this.ctx, this.bean);
        }
        catch (Exception e) {
            this.bean._ebean_getIntercept().setLoadError(prop.propertyIndex(), e);
            this.ctx.handleLoadError(prop.fullName(), e);
            return prop.getValue(this.bean);
        }
    }

    public void load(BeanProperty target, Object dbVal) {
        target.setValue(this.bean, dbVal);
    }
}

