/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import java.util.Properties;

final class ConfigPropertiesHelper {
    private final Properties properties;
    private final String prefix;
    private final String poolName;

    ConfigPropertiesHelper(String prefix, String poolName, Properties properties) {
        this.poolName = poolName;
        this.prefix = prefix;
        this.properties = properties;
    }

    private String read(String key) {
        String val = this.properties.getProperty(key.toLowerCase());
        if (val == null) {
            return this.properties.getProperty(key);
        }
        return val;
    }

    String get(String key, String defaultValue) {
        String value = null;
        if (this.poolName != null && this.prefix != null) {
            value = this.read(this.prefix + "." + this.poolName + "." + key);
        }
        if (value == null && this.prefix != null) {
            value = this.read(this.prefix + "." + key);
        }
        if (value == null) {
            value = this.read(key);
        }
        return value == null ? defaultValue : value;
    }

    int getInt(String key, int defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Integer.parseInt(value);
    }

    boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(value);
    }
}

