/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import io.ebean.datasource.ConfigPropertiesHelper;
import io.ebean.datasource.DataSourceAlert;
import io.ebean.datasource.DataSourcePoolListener;
import io.ebean.datasource.InitDatabase;
import io.ebean.datasource.PostgresInitDatabase;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DataSourceConfig {
    private static final String POSTGRES = "postgres";
    private InitDatabase initDatabase;
    private String readOnlyUrl;
    private String url;
    private String username;
    private String password;
    private String schema;
    private String platform;
    private String ownerUsername;
    private String ownerPassword;
    private String driver;
    private int minConnections = 2;
    private int maxConnections = 200;
    private int isolationLevel = 2;
    private boolean autoCommit;
    private boolean readOnly;
    private String heartbeatSql;
    private int heartbeatFreqSecs = 30;
    private int heartbeatTimeoutSeconds = 3;
    private boolean captureStackTrace;
    private int maxStackTraceSize = 5;
    private int leakTimeMinutes = 30;
    private int maxInactiveTimeSecs = 300;
    private int maxAgeMinutes = 0;
    private int trimPoolFreqSecs = 59;
    private int pstmtCacheSize = 50;
    private int cstmtCacheSize = 20;
    private int waitTimeoutMillis = 1000;
    private String poolListener;
    private boolean offline;
    private boolean failOnStart = true;
    private Map<String, String> customProperties;
    private List<String> initSql;
    private DataSourceAlert alert;
    private DataSourcePoolListener listener;

    public DataSourceConfig copy() {
        DataSourceConfig copy = new DataSourceConfig();
        copy.initDatabase = this.initDatabase;
        copy.url = this.url;
        copy.readOnlyUrl = this.readOnlyUrl;
        copy.username = this.username;
        copy.password = this.password;
        copy.schema = this.schema;
        copy.platform = this.platform;
        copy.ownerUsername = this.ownerUsername;
        copy.ownerPassword = this.ownerPassword;
        copy.driver = this.driver;
        copy.minConnections = this.minConnections;
        copy.maxConnections = this.maxConnections;
        copy.isolationLevel = this.isolationLevel;
        copy.autoCommit = this.autoCommit;
        copy.readOnly = this.readOnly;
        copy.heartbeatSql = this.heartbeatSql;
        copy.heartbeatFreqSecs = this.heartbeatFreqSecs;
        copy.heartbeatTimeoutSeconds = this.heartbeatTimeoutSeconds;
        copy.captureStackTrace = this.captureStackTrace;
        copy.maxStackTraceSize = this.maxStackTraceSize;
        copy.leakTimeMinutes = this.leakTimeMinutes;
        copy.maxInactiveTimeSecs = this.maxInactiveTimeSecs;
        copy.maxAgeMinutes = this.maxAgeMinutes;
        copy.trimPoolFreqSecs = this.trimPoolFreqSecs;
        copy.pstmtCacheSize = this.pstmtCacheSize;
        copy.cstmtCacheSize = this.cstmtCacheSize;
        copy.waitTimeoutMillis = this.waitTimeoutMillis;
        copy.poolListener = this.poolListener;
        copy.offline = this.offline;
        copy.failOnStart = this.failOnStart;
        if (this.customProperties != null) {
            copy.customProperties = new LinkedHashMap<String, String>(this.customProperties);
        }
        copy.initSql = this.initSql;
        copy.alert = this.alert;
        copy.listener = this.listener;
        return copy;
    }

    public DataSourceConfig setDefaults(DataSourceConfig other) {
        if (this.driver == null) {
            this.driver = other.driver;
        }
        if (this.url == null) {
            this.url = other.url;
        }
        if (this.username == null) {
            this.username = other.username;
        }
        if (this.password == null) {
            this.password = other.password;
        }
        if (this.schema == null) {
            this.schema = other.schema;
        }
        if (this.customProperties == null && other.customProperties != null) {
            this.customProperties = new LinkedHashMap<String, String>(other.customProperties);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.url == null && this.driver == null && this.username == null && this.password == null;
    }

    public String getReadOnlyUrl() {
        return this.readOnlyUrl;
    }

    public DataSourceConfig setReadOnlyUrl(String readOnlyUrl) {
        this.readOnlyUrl = readOnlyUrl;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public DataSourceConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DataSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public DataSourceConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getDriver() {
        return this.driver;
    }

    public DataSourceConfig setDriver(String driver) {
        this.driver = driver;
        return this;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public DataSourceConfig setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public DataSourceConfig setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DataSourceConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public DataSourceConfig setMinConnections(int minConnections) {
        this.minConnections = minConnections;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public DataSourceConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public DataSourceAlert getAlert() {
        return this.alert;
    }

    public DataSourceConfig setAlert(DataSourceAlert alert) {
        this.alert = alert;
        return this;
    }

    public DataSourcePoolListener getListener() {
        return this.listener;
    }

    public DataSourceConfig setListener(DataSourcePoolListener listener) {
        this.listener = listener;
        return this;
    }

    public String getHeartbeatSql() {
        return this.heartbeatSql;
    }

    public DataSourceConfig setHeartbeatSql(String heartbeatSql) {
        this.heartbeatSql = heartbeatSql;
        return this;
    }

    public int getHeartbeatFreqSecs() {
        return this.heartbeatFreqSecs;
    }

    public DataSourceConfig setHeartbeatFreqSecs(int heartbeatFreqSecs) {
        this.heartbeatFreqSecs = heartbeatFreqSecs;
        return this;
    }

    public int getHeartbeatTimeoutSeconds() {
        return this.heartbeatTimeoutSeconds;
    }

    public DataSourceConfig setHeartbeatTimeoutSeconds(int heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
        return this;
    }

    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    public DataSourceConfig setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
        return this;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public DataSourceConfig setMaxStackTraceSize(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
        return this;
    }

    public int getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    public DataSourceConfig setLeakTimeMinutes(int leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
        return this;
    }

    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    public DataSourceConfig setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
        return this;
    }

    public int getCstmtCacheSize() {
        return this.cstmtCacheSize;
    }

    public DataSourceConfig setCstmtCacheSize(int cstmtCacheSize) {
        this.cstmtCacheSize = cstmtCacheSize;
        return this;
    }

    public int getWaitTimeoutMillis() {
        return this.waitTimeoutMillis;
    }

    public DataSourceConfig setWaitTimeoutMillis(int waitTimeoutMillis) {
        this.waitTimeoutMillis = waitTimeoutMillis;
        return this;
    }

    public int getMaxInactiveTimeSecs() {
        return this.maxInactiveTimeSecs;
    }

    public int getMaxAgeMinutes() {
        return this.maxAgeMinutes;
    }

    public DataSourceConfig setMaxAgeMinutes(int maxAgeMinutes) {
        this.maxAgeMinutes = maxAgeMinutes;
        return this;
    }

    public DataSourceConfig setMaxInactiveTimeSecs(int maxInactiveTimeSecs) {
        this.maxInactiveTimeSecs = maxInactiveTimeSecs;
        return this;
    }

    public int getTrimPoolFreqSecs() {
        return this.trimPoolFreqSecs;
    }

    public DataSourceConfig setTrimPoolFreqSecs(int trimPoolFreqSecs) {
        this.trimPoolFreqSecs = trimPoolFreqSecs;
        return this;
    }

    public String getPoolListener() {
        return this.poolListener;
    }

    public DataSourceConfig setPoolListener(String poolListener) {
        this.poolListener = poolListener;
        return this;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isFailOnStart() {
        return this.failOnStart;
    }

    public DataSourceConfig setFailOnStart(boolean failOnStart) {
        this.failOnStart = failOnStart;
        return this;
    }

    public DataSourceConfig setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public List<String> getInitSql() {
        return this.initSql;
    }

    public DataSourceConfig setInitSql(List<String> initSql) {
        this.initSql = initSql;
        return this;
    }

    public DataSourceConfig setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public DataSourceConfig addProperty(String key, String value) {
        if (this.customProperties == null) {
            this.customProperties = new LinkedHashMap<String, String>();
        }
        this.customProperties.put(key, value);
        return this;
    }

    public DataSourceConfig addProperty(String key, boolean value) {
        return this.addProperty(key, Boolean.toString(value));
    }

    public DataSourceConfig addProperty(String key, int value) {
        return this.addProperty(key, Integer.toString(value));
    }

    public String getOwnerUsername() {
        return this.ownerUsername;
    }

    public DataSourceConfig setOwnerUsername(String ownerUsername) {
        this.ownerUsername = ownerUsername;
        return this;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public DataSourceConfig setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public DataSourceConfig setPlatform(String platform) {
        this.platform = platform;
        if (this.initDatabase != null) {
            this.setInitDatabaseForPlatform(platform);
        }
        return this;
    }

    public InitDatabase getInitDatabase() {
        return this.initDatabase;
    }

    public DataSourceConfig setInitDatabase(InitDatabase initDatabase) {
        this.initDatabase = initDatabase;
        return this;
    }

    public DataSourceConfig setInitDatabaseForPlatform(String platform) {
        if (platform != null && POSTGRES.equalsIgnoreCase(platform)) {
            this.initDatabase = new PostgresInitDatabase();
        }
        return this;
    }

    public boolean useInitDatabase() {
        if (this.ownerUsername != null && this.ownerPassword != null) {
            if (this.initDatabase == null) {
                this.initDatabase = new PostgresInitDatabase();
            }
            return true;
        }
        return false;
    }

    public DataSourceConfig loadSettings(Properties properties, String serverName) {
        ConfigPropertiesHelper dbProps = new ConfigPropertiesHelper("datasource", serverName, properties);
        this.loadSettings(dbProps);
        return this;
    }

    private void loadSettings(ConfigPropertiesHelper properties) {
        this.username = properties.get("username", this.username);
        this.password = properties.get("password", this.password);
        this.schema = properties.get("schema", this.schema);
        this.platform = properties.get("platform", this.platform);
        this.ownerUsername = properties.get("ownerUsername", this.ownerUsername);
        this.ownerPassword = properties.get("ownerPassword", this.ownerPassword);
        if (this.initDatabase == null && this.platform != null) {
            this.setInitDatabaseForPlatform(this.platform);
        }
        this.driver = properties.get("driver", properties.get("databaseDriver", this.driver));
        this.readOnlyUrl = properties.get("readOnlyUrl", this.readOnlyUrl);
        this.url = properties.get("url", properties.get("databaseUrl", this.url));
        this.autoCommit = properties.getBoolean("autoCommit", this.autoCommit);
        this.readOnly = properties.getBoolean("readOnly", this.readOnly);
        this.captureStackTrace = properties.getBoolean("captureStackTrace", this.captureStackTrace);
        this.maxStackTraceSize = properties.getInt("maxStackTraceSize", this.maxStackTraceSize);
        this.leakTimeMinutes = properties.getInt("leakTimeMinutes", this.leakTimeMinutes);
        this.maxInactiveTimeSecs = properties.getInt("maxInactiveTimeSecs", this.maxInactiveTimeSecs);
        this.trimPoolFreqSecs = properties.getInt("trimPoolFreqSecs", this.trimPoolFreqSecs);
        this.maxAgeMinutes = properties.getInt("maxAgeMinutes", this.maxAgeMinutes);
        this.minConnections = properties.getInt("minConnections", this.minConnections);
        this.maxConnections = properties.getInt("maxConnections", this.maxConnections);
        this.pstmtCacheSize = properties.getInt("pstmtCacheSize", this.pstmtCacheSize);
        this.cstmtCacheSize = properties.getInt("cstmtCacheSize", this.cstmtCacheSize);
        this.waitTimeoutMillis = properties.getInt("waitTimeout", this.waitTimeoutMillis);
        this.heartbeatSql = properties.get("heartbeatSql", this.heartbeatSql);
        this.heartbeatTimeoutSeconds = properties.getInt("heartbeatTimeoutSeconds", this.heartbeatTimeoutSeconds);
        this.poolListener = properties.get("poolListener", this.poolListener);
        this.offline = properties.getBoolean("offline", this.offline);
        String isoLevel = properties.get("isolationLevel", this.getTransactionIsolationLevel(this.isolationLevel));
        this.isolationLevel = this.getTransactionIsolationLevel(isoLevel);
        this.initSql = this.parseSql(properties.get("initSql", null));
        this.failOnStart = properties.getBoolean("failOnStart", this.failOnStart);
        String customProperties = properties.get("customProperties", null);
        if (customProperties != null && customProperties.length() > 0) {
            this.customProperties = this.parseCustom(customProperties);
        }
    }

    private List<String> parseSql(String sql) {
        ArrayList<String> ret = new ArrayList<String>();
        if (sql != null) {
            String[] queries;
            for (String query : queries = sql.split(";")) {
                if ((query = query.trim()).isEmpty()) continue;
                ret.add(query);
            }
        }
        return ret;
    }

    Map<String, String> parseCustom(String customProperties) {
        String[] pairs;
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
        for (String pair : pairs = customProperties.split(";")) {
            String[] split = pair.split("=");
            if (split.length != 2) continue;
            propertyMap.put(split[0], split[1]);
        }
        return propertyMap;
    }

    private String getTransactionIsolationLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }

    private int getTransactionIsolationLevel(String level) {
        if ((level = level.toUpperCase()).startsWith("TRANSACTION")) {
            level = level.substring("TRANSACTION".length());
        }
        if ("NONE".equalsIgnoreCase(level = level.replace("_", ""))) {
            return 0;
        }
        if ("READCOMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READUNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("REPEATABLEREAD".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }
}

